/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.api.events.cache;

import ai.pipestream.api.events.cache.ConsulClusterPipelineChangedEvent;
import ai.pipestream.api.events.cache.ConsulModuleRegistrationChangedEvent;
import ai.pipestream.api.events.cache.ConsulPipelineDefinitionChangedEvent;
import io.quarkus.cache.Cache;
import io.quarkus.cache.CacheManager;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Optional;
import org.jboss.logging.Logger;

@ApplicationScoped
public class CacheInvalidationHandler {
    private static final Logger LOG = Logger.getLogger(CacheInvalidationHandler.class);
    @Inject
    CacheManager cacheManager;

    public void onPipelineDefinitionChanged(@Observes ConsulPipelineDefinitionChangedEvent event) {
        LOG.infof("Pipeline definition changed: %s - invalidating caches", (Object)event.pipelineId());
        this.invalidateCache("pipeline-definitions", event.pipelineId());
        this.invalidateAllCache("pipeline-definitions-list");
        this.invalidateCache("pipeline-definitions-exists", event.pipelineId());
        this.invalidateCache("pipeline-metadata", event.pipelineId());
    }

    public void onModuleRegistrationChanged(@Observes ConsulModuleRegistrationChangedEvent event) {
        LOG.infof("Module registration changed: %s - invalidating caches", (Object)event.moduleId());
        this.invalidateAllCache("global-modules-list");
        this.invalidateAllCache("global-modules-enabled");
        this.invalidateCache("global-modules", event.moduleId());
        this.invalidateCache("module-health-status", event.moduleId());
    }

    public void onClusterPipelineChanged(@Observes ConsulClusterPipelineChangedEvent event) {
        LOG.infof("Cluster pipeline changed: %s/%s - invalidating caches", (Object)event.clusterName(), (Object)event.pipelineId());
        this.invalidateCache("cluster-pipelines-list", event.clusterName());
        this.invalidateCache("cluster-pipelines", event.clusterName(), event.pipelineId());
    }

    private void invalidateCache(String cacheName, Object ... keys) {
        try {
            Optional cacheOpt = this.cacheManager.getCache(cacheName);
            if (cacheOpt.isPresent()) {
                Cache cache = (Cache)cacheOpt.get();
                if (keys.length == 0) {
                    cache.invalidateAll().await().indefinitely();
                } else if (keys.length == 1) {
                    cache.invalidate(keys[0]).await().indefinitely();
                } else {
                    String compositeKey = String.join((CharSequence)":", (CharSequence[])Arrays.stream(keys).map(Object::toString).toArray(String[]::new));
                    cache.invalidate((Object)compositeKey).await().indefinitely();
                }
                LOG.debugf("Invalidated cache %s for key(s): %s", (Object)cacheName, (Object)Arrays.toString(keys));
            } else {
                LOG.debugf("Cache %s not found - may not be initialized yet", (Object)cacheName);
            }
        }
        catch (Exception e) {
            LOG.warnf((Throwable)e, "Failed to invalidate cache %s", (Object)cacheName);
        }
    }

    private void invalidateAllCache(String cacheName) {
        try {
            Optional cacheOpt = this.cacheManager.getCache(cacheName);
            if (cacheOpt.isPresent()) {
                Cache cache = (Cache)cacheOpt.get();
                cache.invalidateAll().await().indefinitely();
                LOG.debugf("Invalidated all entries in cache %s", (Object)cacheName);
            } else {
                LOG.debugf("Cache %s not found - may not be initialized yet", (Object)cacheName);
            }
        }
        catch (Exception e) {
            LOG.warnf((Throwable)e, "Failed to invalidate all entries in cache %s", (Object)cacheName);
        }
    }
}

