/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.api.json;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Singleton;

@Singleton
public class ObjectMapperFactory {
    private static final ObjectMapper STATIC_CONFIGURED_MAPPER = ObjectMapperFactory.createStaticConfiguredMapper();

    public static ObjectMapper createConfiguredMapper() {
        return STATIC_CONFIGURED_MAPPER;
    }

    private static ObjectMapper createStaticConfiguredMapper() {
        return ObjectMapperFactory.applyConfigurationToBuilder(JsonMapper.builder()).build();
    }

    @Singleton
    @Produces
    public ObjectMapper produceObjectMapper() {
        return ObjectMapperFactory.createConfiguredMapper();
    }

    public static ObjectMapper createMinimalMapper() {
        return ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).addModule((Module)new JavaTimeModule())).build();
    }

    private static JsonMapper.Builder applyConfigurationToBuilder(JsonMapper.Builder builder) {
        return (JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)builder.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true)).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true)).propertyNamingStrategy(PropertyNamingStrategies.LOWER_CAMEL_CASE)).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false)).configure(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS, false)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).addModule((Module)new JavaTimeModule());
    }
}

