/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.api.registration;

import ai.pipestream.api.annotation.GrpcServiceRegistration;
import ai.pipestream.api.registration.IconResourceLoader;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

@ApplicationScoped
public class ServiceMetadataCollector {
    private static final Logger LOG = Logger.getLogger(ServiceMetadataCollector.class);
    @Inject
    IconResourceLoader iconLoader;
    private final Config config = ConfigProvider.getConfig();

    public ServiceMetadata collectServiceMetadata(Class<?> serviceClass, GrpcServiceRegistration annotation) {
        String serviceName = this.determineServiceName(serviceClass, annotation);
        return ServiceMetadata.builder().serviceName(serviceName).serviceId(this.generateServiceId(serviceName)).serviceType(annotation.serviceType()).description(this.resolveConfigValue(annotation.description(), serviceName + ".description")).version(this.resolveConfigValue(annotation.version(), serviceName + ".version")).host(this.determineHost(serviceName)).port(this.determinePort(serviceName)).grpcPort(this.determineGrpcPort(serviceName)).iconSvgBase64(this.loadServiceIcon(annotation.iconPath(), serviceName)).capabilities(this.collectCapabilities(annotation, serviceName)).tags(this.collectTags(annotation, serviceName)).metadata(this.collectCustomMetadata(annotation, serviceName, serviceClass)).healthChecks(this.collectHealthChecks(annotation, serviceName)).registeredAt(Instant.now()).registeredBy(this.determineRegisteredBy()).build();
    }

    private String determineServiceName(Class<?> serviceClass, GrpcServiceRegistration annotation) {
        if (!annotation.serviceName().isEmpty()) {
            return this.resolveConfigValue(annotation.serviceName(), "service.name");
        }
        Optional configName = this.config.getOptionalValue("quarkus.application.name", String.class);
        if (configName.isPresent()) {
            return (String)configName.get();
        }
        String className = serviceClass.getSimpleName();
        if (className.endsWith("Impl")) {
            className = className.substring(0, className.length() - 4);
        }
        if (className.endsWith("Service")) {
            className = className.substring(0, className.length() - 7);
        }
        return className.toLowerCase().replaceAll("([a-z])([A-Z])", "$1-$2");
    }

    private String generateServiceId(String serviceName) {
        String hostname = this.getHostname();
        long timestamp = System.currentTimeMillis();
        return String.format("%s-%s-%d", serviceName, hostname, timestamp);
    }

    private String determineHost(String serviceName) {
        String hostKey = String.format("service.registration.%s.host", serviceName);
        Optional serviceHost = this.config.getOptionalValue(hostKey, String.class);
        if (serviceHost.isPresent()) {
            return (String)serviceHost.get();
        }
        Optional registrationHost = this.config.getOptionalValue("service.registration.host", String.class);
        if (registrationHost.isPresent()) {
            return (String)registrationHost.get();
        }
        Optional httpHost = this.config.getOptionalValue("quarkus.http.host", String.class);
        if (httpHost.isPresent() && !"0.0.0.0".equals(httpHost.get())) {
            return (String)httpHost.get();
        }
        String envHost = System.getenv("SERVICE_HOST");
        if (envHost != null && !envHost.isEmpty()) {
            return envHost;
        }
        return this.getHostname();
    }

    private int determinePort(String serviceName) {
        String portKey = String.format("service.registration.%s.port", serviceName);
        Optional servicePort = this.config.getOptionalValue(portKey, Integer.class);
        if (servicePort.isPresent()) {
            return (Integer)servicePort.get();
        }
        return this.config.getOptionalValue("quarkus.http.port", Integer.class).orElse(8080);
    }

    private int determineGrpcPort(String serviceName) {
        String grpcPortKey = String.format("service.registration.%s.grpc-port", serviceName);
        Optional serviceGrpcPort = this.config.getOptionalValue(grpcPortKey, Integer.class);
        if (serviceGrpcPort.isPresent()) {
            return (Integer)serviceGrpcPort.get();
        }
        boolean separateGrpcServer = this.config.getOptionalValue("quarkus.grpc.server.use-separate-server", Boolean.class).orElse(true);
        if (separateGrpcServer) {
            return this.config.getOptionalValue("quarkus.grpc.server.port", Integer.class).orElse(9000);
        }
        return this.determinePort(serviceName);
    }

    private String loadServiceIcon(String iconPath, String serviceName) {
        Optional<String> icon;
        String resolvedPath;
        Optional<String> icon2;
        if (!iconPath.isEmpty() && (icon2 = this.iconLoader.loadIcon(resolvedPath = this.resolveConfigValue(iconPath, serviceName + ".icon-path"))).isPresent()) {
            return icon2.get();
        }
        String iconConfigKey = String.format("service.registration.%s.icon-path", serviceName);
        Optional configIconPath = this.config.getOptionalValue(iconConfigKey, String.class);
        if (configIconPath.isPresent() && (icon = this.iconLoader.loadIcon((String)configIconPath.get())).isPresent()) {
            return icon.get();
        }
        return this.iconLoader.getDefaultServiceIcon();
    }

    private Set<String> collectCapabilities(GrpcServiceRegistration annotation, String serviceName) {
        HashSet<String> capabilities = new HashSet<String>();
        capabilities.addAll(Arrays.asList(annotation.capabilities()));
        String capabilitiesKey = String.format("service.registration.%s.capabilities", serviceName);
        Optional configCapabilities = this.config.getOptionalValue(capabilitiesKey, String.class);
        if (configCapabilities.isPresent()) {
            String[] caps;
            for (String cap : caps = ((String)configCapabilities.get()).split(",")) {
                capabilities.add(cap.trim());
            }
        }
        return capabilities;
    }

    private Set<String> collectTags(GrpcServiceRegistration annotation, String serviceName) {
        HashSet<String> tags = new HashSet<String>();
        tags.addAll(Arrays.asList(annotation.tags()));
        String tagsKey = String.format("service.registration.%s.tags", serviceName);
        Optional configTags = this.config.getOptionalValue(tagsKey, String.class);
        if (configTags.isPresent()) {
            String[] tagArray;
            for (String tag : tagArray = ((String)configTags.get()).split(",")) {
                tags.add(tag.trim());
            }
        }
        tags.add("grpc");
        tags.add("service");
        tags.add("version:" + this.resolveConfigValue(annotation.version(), serviceName + ".version"));
        return tags;
    }

    private Map<String, String> collectCustomMetadata(GrpcServiceRegistration annotation, String serviceName, Class<?> serviceClass) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("service-class", serviceClass.getName());
        metadata.put("java-version", System.getProperty("java.version"));
        metadata.put("startup-time", Instant.now().toString());
        this.config.getOptionalValue("quarkus.application.version", String.class).ifPresent(v -> metadata.put("quarkus-version", (String)v));
        for (String meta : annotation.metadata()) {
            String[] parts = meta.split("=", 2);
            if (parts.length != 2) continue;
            String key = parts[0].trim();
            String value = this.resolveConfigValue(parts[1].trim(), serviceName + ".metadata." + key);
            metadata.put(key, value);
        }
        String metadataPrefix = String.format("service.registration.%s.metadata.", serviceName);
        for (String propertyName : this.config.getPropertyNames()) {
            if (!propertyName.startsWith(metadataPrefix)) continue;
            String key = propertyName.substring(metadataPrefix.length());
            String value = (String)this.config.getValue(propertyName, String.class);
            metadata.put(key, value);
        }
        Set<String> grpcMethods = this.extractGrpcMethods(serviceClass);
        if (!grpcMethods.isEmpty()) {
            metadata.put("grpc-methods", String.join((CharSequence)",", grpcMethods));
            metadata.put("method-count", String.valueOf(grpcMethods.size()));
        }
        return metadata;
    }

    private Set<String> extractGrpcMethods(Class<?> serviceClass) {
        HashSet<String> methods = new HashSet<String>();
        for (Method method : serviceClass.getDeclaredMethods()) {
            if (method.isSynthetic() || method.isBridge() || !method.getReturnType().getName().contains("Uni") && method.getParameterCount() <= 0) continue;
            methods.add(method.getName());
        }
        return methods;
    }

    private List<HealthCheckConfig> collectHealthChecks(GrpcServiceRegistration annotation, String serviceName) {
        ArrayList<HealthCheckConfig> healthChecks = new ArrayList<HealthCheckConfig>();
        block5: for (GrpcServiceRegistration.HealthCheckType type : annotation.healthChecks()) {
            switch (type) {
                case HTTP: {
                    healthChecks.add(this.createHttpHealthCheck(serviceName));
                    continue block5;
                }
                case GRPC: {
                    healthChecks.add(this.createGrpcHealthCheck(serviceName));
                    continue block5;
                }
                case TCP: {
                    healthChecks.add(this.createTcpHealthCheck(serviceName));
                }
            }
        }
        return healthChecks;
    }

    private HealthCheckConfig createHttpHealthCheck(String serviceName) {
        String endpoint = this.config.getOptionalValue(String.format("service.registration.%s.health-check.http.endpoint", serviceName), String.class).orElse("/q/health");
        String interval = this.config.getOptionalValue(String.format("service.registration.%s.health-check.http.interval", serviceName), String.class).orElse("10s");
        return HealthCheckConfig.builder().type(GrpcServiceRegistration.HealthCheckType.HTTP).endpoint(endpoint).interval(interval).timeout("5s").deregisterAfter("1m").build();
    }

    private HealthCheckConfig createGrpcHealthCheck(String serviceName) {
        String interval = this.config.getOptionalValue(String.format("service.registration.%s.health-check.grpc.interval", serviceName), String.class).orElse("10s");
        return HealthCheckConfig.builder().type(GrpcServiceRegistration.HealthCheckType.GRPC).endpoint("").interval(interval).timeout("5s").deregisterAfter("1m").build();
    }

    private HealthCheckConfig createTcpHealthCheck(String serviceName) {
        String interval = this.config.getOptionalValue(String.format("service.registration.%s.health-check.tcp.interval", serviceName), String.class).orElse("10s");
        return HealthCheckConfig.builder().type(GrpcServiceRegistration.HealthCheckType.TCP).endpoint("").interval(interval).timeout("3s").deregisterAfter("30s").build();
    }

    private String resolveConfigValue(String value, String fallbackKey) {
        if (value == null || value.isEmpty()) {
            return this.config.getOptionalValue(fallbackKey, String.class).orElse("");
        }
        if (value.startsWith("${") && value.endsWith("}")) {
            String placeholder = value.substring(2, value.length() - 1);
            String[] parts = placeholder.split(":", 2);
            String propertyName = parts[0];
            String defaultValue = parts.length > 1 ? parts[1] : "";
            return this.config.getOptionalValue(propertyName, String.class).orElse(defaultValue);
        }
        return value;
    }

    private String getHostname() {
        try {
            String hostname = System.getenv("HOSTNAME");
            if (hostname != null && !hostname.isEmpty()) {
                return hostname;
            }
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.warn((Object)"Could not determine hostname, using 'localhost'", (Throwable)e);
            return "localhost";
        }
    }

    private String determineRegisteredBy() {
        return String.format("service-registration-processor@%s", this.getHostname());
    }

    public static class ServiceMetadata {
        private final String serviceName;
        private final String serviceId;
        private final GrpcServiceRegistration.ServiceType serviceType;
        private final String description;
        private final String version;
        private final String host;
        private final int port;
        private final int grpcPort;
        private final String iconSvgBase64;
        private final Set<String> capabilities;
        private final Set<String> tags;
        private final Map<String, String> metadata;
        private final List<HealthCheckConfig> healthChecks;
        private final Instant registeredAt;
        private final String registeredBy;

        private ServiceMetadata(Builder builder) {
            this.serviceName = builder.serviceName;
            this.serviceId = builder.serviceId;
            this.serviceType = builder.serviceType;
            this.description = builder.description;
            this.version = builder.version;
            this.host = builder.host;
            this.port = builder.port;
            this.grpcPort = builder.grpcPort;
            this.iconSvgBase64 = builder.iconSvgBase64;
            this.capabilities = Set.copyOf(builder.capabilities);
            this.tags = Set.copyOf(builder.tags);
            this.metadata = Map.copyOf(builder.metadata);
            this.healthChecks = List.copyOf(builder.healthChecks);
            this.registeredAt = builder.registeredAt;
            this.registeredBy = builder.registeredBy;
        }

        public static Builder builder() {
            return new Builder();
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public GrpcServiceRegistration.ServiceType getServiceType() {
            return this.serviceType;
        }

        public String getDescription() {
            return this.description;
        }

        public String getVersion() {
            return this.version;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public int getGrpcPort() {
            return this.grpcPort;
        }

        public String getIconSvgBase64() {
            return this.iconSvgBase64;
        }

        public Set<String> getCapabilities() {
            return this.capabilities;
        }

        public Set<String> getTags() {
            return this.tags;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        public List<HealthCheckConfig> getHealthChecks() {
            return this.healthChecks;
        }

        public Instant getRegisteredAt() {
            return this.registeredAt;
        }

        public String getRegisteredBy() {
            return this.registeredBy;
        }

        public static class Builder {
            private String serviceName;
            private String serviceId;
            private GrpcServiceRegistration.ServiceType serviceType;
            private String description = "";
            private String version = "1.0.0";
            private String host;
            private int port;
            private int grpcPort;
            private String iconSvgBase64 = "";
            private Set<String> capabilities = new HashSet<String>();
            private Set<String> tags = new HashSet<String>();
            private Map<String, String> metadata = new HashMap<String, String>();
            private List<HealthCheckConfig> healthChecks = new ArrayList<HealthCheckConfig>();
            private Instant registeredAt;
            private String registeredBy;

            public Builder serviceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            public Builder serviceId(String serviceId) {
                this.serviceId = serviceId;
                return this;
            }

            public Builder serviceType(GrpcServiceRegistration.ServiceType serviceType) {
                this.serviceType = serviceType;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public Builder host(String host) {
                this.host = host;
                return this;
            }

            public Builder port(int port) {
                this.port = port;
                return this;
            }

            public Builder grpcPort(int grpcPort) {
                this.grpcPort = grpcPort;
                return this;
            }

            public Builder iconSvgBase64(String iconSvgBase64) {
                this.iconSvgBase64 = iconSvgBase64;
                return this;
            }

            public Builder capabilities(Set<String> capabilities) {
                this.capabilities = capabilities;
                return this;
            }

            public Builder tags(Set<String> tags) {
                this.tags = tags;
                return this;
            }

            public Builder metadata(Map<String, String> metadata) {
                this.metadata = metadata;
                return this;
            }

            public Builder healthChecks(List<HealthCheckConfig> healthChecks) {
                this.healthChecks = healthChecks;
                return this;
            }

            public Builder registeredAt(Instant registeredAt) {
                this.registeredAt = registeredAt;
                return this;
            }

            public Builder registeredBy(String registeredBy) {
                this.registeredBy = registeredBy;
                return this;
            }

            public ServiceMetadata build() {
                return new ServiceMetadata(this);
            }
        }
    }

    public static class HealthCheckConfig {
        private final GrpcServiceRegistration.HealthCheckType type;
        private final String endpoint;
        private final String interval;
        private final String timeout;
        private final String deregisterAfter;

        private HealthCheckConfig(Builder builder) {
            this.type = builder.type;
            this.endpoint = builder.endpoint;
            this.interval = builder.interval;
            this.timeout = builder.timeout;
            this.deregisterAfter = builder.deregisterAfter;
        }

        public static Builder builder() {
            return new Builder();
        }

        public GrpcServiceRegistration.HealthCheckType getType() {
            return this.type;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getInterval() {
            return this.interval;
        }

        public String getTimeout() {
            return this.timeout;
        }

        public String getDeregisterAfter() {
            return this.deregisterAfter;
        }

        public static class Builder {
            private GrpcServiceRegistration.HealthCheckType type;
            private String endpoint;
            private String interval;
            private String timeout;
            private String deregisterAfter;

            public Builder type(GrpcServiceRegistration.HealthCheckType type) {
                this.type = type;
                return this;
            }

            public Builder endpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public Builder interval(String interval) {
                this.interval = interval;
                return this;
            }

            public Builder timeout(String timeout) {
                this.timeout = timeout;
                return this;
            }

            public Builder deregisterAfter(String deregisterAfter) {
                this.deregisterAfter = deregisterAfter;
                return this;
            }

            public HealthCheckConfig build() {
                return new HealthCheckConfig(this);
            }
        }
    }
}

