/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.common.interceptor;

import ai.pipestream.api.annotation.ProcessingBuffered;
import ai.pipestream.common.util.ProcessingBuffer;
import ai.pipestream.common.util.ProcessingBufferFactory;
import ai.pipestream.data.module.ModuleProcessResponse;
import ai.pipestream.data.v1.PipeDoc;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@ProcessingBuffered(type=PipeDoc.class)
@Interceptor
@Priority(value=2100)
public class ProcessingBufferInterceptor {
    private static final Logger LOG = Logger.getLogger(ProcessingBufferInterceptor.class);
    private static final ConcurrentMap<String, ProcessingBuffer<PipeDoc>> bufferCache = new ConcurrentHashMap<String, ProcessingBuffer<PipeDoc>>();
    @Inject
    @ConfigProperty(name="quarkus.application.name", defaultValue="unknown-module")
    String applicationName;

    @AroundInvoke
    public Object captureProcessingOutput(InvocationContext context) throws Exception {
        ProcessingBuffered annotation = this.getProcessingBufferedAnnotation(context);
        if (annotation == null) {
            return context.proceed();
        }
        boolean bufferEnabled = this.resolveConfigValue(annotation.enabled(), "processing.buffer.enabled", false);
        if (!bufferEnabled) {
            LOG.debugf("Processing buffer disabled for method: %s", (Object)context.getMethod().getName());
            return context.proceed();
        }
        String methodKey = this.getMethodKey(context);
        ProcessingBuffer<PipeDoc> buffer = this.getOrCreateBuffer(methodKey, annotation);
        Object result = context.proceed();
        if (result instanceof Uni) {
            Uni originalUni = (Uni)result;
            return originalUni.onItem().transform(item -> {
                this.captureFromProcessResponse(item, buffer);
                return item;
            });
        }
        this.captureFromProcessResponse(result, buffer);
        return result;
    }

    private ProcessingBuffered getProcessingBufferedAnnotation(InvocationContext context) {
        ProcessingBuffered methodAnnotation = context.getMethod().getAnnotation(ProcessingBuffered.class);
        if (methodAnnotation != null) {
            return methodAnnotation;
        }
        return context.getTarget().getClass().getAnnotation(ProcessingBuffered.class);
    }

    private String getMethodKey(InvocationContext context) {
        return context.getTarget().getClass().getSimpleName() + "." + context.getMethod().getName();
    }

    private ProcessingBuffer<PipeDoc> getOrCreateBuffer(String methodKey, ProcessingBuffered annotation) {
        return bufferCache.computeIfAbsent(methodKey, key -> {
            int capacity = this.resolveConfigValue(annotation.capacity(), "processing.buffer.capacity", 100);
            String directory = this.resolveConfigValue(annotation.directory(), "processing.buffer.directory", "target/test-data");
            String prefix = this.resolveConfigValue(annotation.prefix(), "processing.buffer.prefix", this.applicationName);
            LOG.infof("Creating ProcessingBuffer for %s: capacity=%d, directory=%s, prefix=%s", new Object[]{key, capacity, directory, prefix});
            return ProcessingBufferFactory.createBuffer(true, capacity, PipeDoc.class);
        });
    }

    private void captureFromProcessResponse(Object result, ProcessingBuffer<PipeDoc> buffer) {
        ModuleProcessResponse response;
        if (result instanceof ModuleProcessResponse && (response = (ModuleProcessResponse)result) != null && response.hasOutputDoc()) {
            PipeDoc outputDoc = response.getOutputDoc();
            buffer.add(outputDoc);
            LOG.debugf("Captured document in buffer: %s (buffer size: %d)", (Object)outputDoc.getDocId(), (Object)buffer.size());
        }
    }

    private <T> T resolveConfigValue(String annotationValue, String configProperty, T defaultValue) {
        if (annotationValue == null || annotationValue.trim().isEmpty()) {
            return this.getConfigValue(configProperty, defaultValue);
        }
        if (annotationValue.startsWith("${") && annotationValue.endsWith("}")) {
            String expression = annotationValue.substring(2, annotationValue.length() - 1);
            String[] parts = expression.split(":", 2);
            String propertyName = parts[0];
            T fallbackDefault = parts.length > 1 ? this.parseValue(parts[1], defaultValue) : defaultValue;
            return this.getConfigValue(propertyName, fallbackDefault);
        }
        return this.parseValue(annotationValue, defaultValue);
    }

    private <T> T getConfigValue(String propertyName, T defaultValue) {
        try {
            if (defaultValue instanceof Boolean) {
                return (T)Boolean.valueOf(System.getProperty(propertyName, defaultValue.toString()));
            }
            if (defaultValue instanceof Integer) {
                return (T)Integer.valueOf(System.getProperty(propertyName, defaultValue.toString()));
            }
            if (defaultValue instanceof String) {
                return (T)System.getProperty(propertyName, (String)defaultValue);
            }
        }
        catch (Exception e) {
            LOG.warnf("Failed to parse config property %s, using default: %s", (Object)propertyName, defaultValue);
        }
        return defaultValue;
    }

    private <T> T parseValue(String value, T defaultValue) {
        try {
            if (defaultValue instanceof Boolean) {
                return (T)Boolean.valueOf(value);
            }
            if (defaultValue instanceof Integer) {
                return (T)Integer.valueOf(value);
            }
            if (defaultValue instanceof String) {
                return (T)value;
            }
        }
        catch (Exception e) {
            LOG.warnf("Failed to parse value '%s', using default: %s", (Object)value, defaultValue);
        }
        return defaultValue;
    }

    public static ProcessingBuffer<PipeDoc> getBuffer(String methodKey) {
        return (ProcessingBuffer)bufferCache.get(methodKey);
    }

    public static ProcessingBuffer<PipeDoc> getBuffer(String className, String methodName) {
        return ProcessingBufferInterceptor.getBuffer(className + "." + methodName);
    }

    public static Set<String> getActiveBufferKeys() {
        return new HashSet<String>(bufferCache.keySet());
    }

    public static int getTotalCapturedDocuments() {
        return bufferCache.values().stream().mapToInt(ProcessingBuffer::size).sum();
    }

    public static void saveAllBuffers() {
        LOG.info((Object)"Saving all active buffers to disk...");
        for (Map.Entry entry : bufferCache.entrySet()) {
            try {
                ProcessingBuffer buffer = (ProcessingBuffer)entry.getValue();
                if (buffer.size() <= 0) continue;
                buffer.saveToDisk();
                LOG.infof("Saved buffer %s: %d documents", entry.getKey(), (Object)buffer.size());
            }
            catch (Exception e) {
                LOG.errorf((Throwable)e, "Failed to save buffer %s", entry.getKey());
            }
        }
        LOG.info((Object)"Completed saving all buffers");
    }

    public static boolean saveBuffer(String methodKey) {
        ProcessingBuffer buffer = (ProcessingBuffer)bufferCache.get(methodKey);
        if (buffer != null && buffer.size() > 0) {
            try {
                buffer.saveToDisk();
                LOG.infof("Saved buffer %s: %d documents", (Object)methodKey, (Object)buffer.size());
                return true;
            }
            catch (Exception e) {
                LOG.errorf((Throwable)e, "Failed to save buffer %s", (Object)methodKey);
            }
        }
        return false;
    }

    public static void clearAllBuffers() {
        LOG.info((Object)"Clearing all active buffers...");
        bufferCache.values().forEach(ProcessingBuffer::clear);
        LOG.infof("Cleared %d buffers", (Object)bufferCache.size());
    }

    public static Map<String, Integer> getBufferStatistics() {
        return bufferCache.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ProcessingBuffer)entry.getValue()).size()));
    }
}

