/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.common.service;

import io.quarkus.arc.Arc;
import io.quarkus.smallrye.openapi.runtime.OpenApiDocumentService;
import io.smallrye.openapi.runtime.io.Format;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.jboss.logging.Logger;

@ApplicationScoped
public class SchemaExtractorService {
    private static final Logger LOG = Logger.getLogger(SchemaExtractorService.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<String> extractSchemaByName(String schemaName) {
        LOG.debugf("Extracting schema for: %s", (Object)schemaName);
        try {
            OpenApiDocumentService documentService = (OpenApiDocumentService)Arc.container().instance(OpenApiDocumentService.class, new Annotation[0]).get();
            if (documentService == null) {
                LOG.warnf("OpenApiDocumentService not available - schema extraction failed for: %s", (Object)schemaName);
                return Optional.empty();
            }
            byte[] jsonBytes = documentService.getDocument(Format.JSON);
            if (jsonBytes == null || jsonBytes.length == 0) {
                LOG.warnf("OpenAPI document is empty - schema extraction failed for: %s", (Object)schemaName);
                return Optional.empty();
            }
            String jsonString = new String(jsonBytes, StandardCharsets.UTF_8);
            LOG.debugf("OpenAPI document size: %d characters", jsonString.length());
            try (JsonReader reader = Json.createReader((Reader)new StringReader(jsonString));){
                JsonObject openApiDoc = reader.readObject();
                JsonObject components = openApiDoc.getJsonObject("components");
                if (components == null) {
                    LOG.debugf("No components section found in OpenAPI document for schema: %s", (Object)schemaName);
                    Optional<String> optional = Optional.empty();
                    return optional;
                }
                JsonObject schemas = components.getJsonObject("schemas");
                if (schemas == null) {
                    LOG.debugf("No schemas section found in OpenAPI components for schema: %s", (Object)schemaName);
                    Optional<String> optional = Optional.empty();
                    return optional;
                }
                JsonObject targetSchema = schemas.getJsonObject(schemaName);
                if (targetSchema == null) {
                    LOG.debugf("Schema '%s' not found in OpenAPI schemas section", (Object)schemaName);
                    Optional<String> optional = Optional.empty();
                    return optional;
                }
                String extractedSchema = targetSchema.toString();
                LOG.debugf("Successfully extracted schema '%s' (%d characters)", (Object)schemaName, (Object)extractedSchema.length());
                Optional<String> optional = Optional.of(extractedSchema);
                return optional;
            }
        }
        catch (Exception e) {
            LOG.errorf((Throwable)e, "Error extracting schema '%s' from OpenAPI document", (Object)schemaName);
            return Optional.empty();
        }
    }

    public Optional<String> extractChunkerConfigSchema() {
        return this.extractSchemaByName("ChunkerConfig");
    }

    public Optional<String> extractChunkerConfigSchemaForValidation() {
        return this.extractSchemaByName("ChunkerConfig").map(this::cleanSchemaForJsonSchemaV7);
    }

    public Optional<String> extractParserConfigSchema() {
        return this.extractSchemaByName("ParserConfig");
    }

    public Optional<String> extractParserConfigSchemaForValidation() {
        return this.extractSchemaByName("ParserConfig").map(this::cleanSchemaForJsonSchemaV7);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<String> extractSchemaResolvedForJsonForms(String schemaName) {
        LOG.debugf("Extracting JSONForms-ready schema for: %s", (Object)schemaName);
        try {
            OpenApiDocumentService documentService = (OpenApiDocumentService)Arc.container().instance(OpenApiDocumentService.class, new Annotation[0]).get();
            if (documentService == null) {
                LOG.warn((Object)"OpenApiDocumentService not available - cannot resolve refs");
                return Optional.empty();
            }
            byte[] jsonBytes = documentService.getDocument(Format.JSON);
            if (jsonBytes == null || jsonBytes.length == 0) {
                LOG.warn((Object)"OpenAPI document is empty - cannot resolve refs");
                return Optional.empty();
            }
            String jsonString = new String(jsonBytes, StandardCharsets.UTF_8);
            try (JsonReader reader = Json.createReader((Reader)new StringReader(jsonString));){
                JsonObject openApiDoc = reader.readObject();
                JsonObject components = openApiDoc.getJsonObject("components");
                if (components == null) {
                    Optional<String> optional = Optional.empty();
                    return optional;
                }
                JsonObject schemas = components.getJsonObject("schemas");
                if (schemas == null) {
                    Optional<String> optional = Optional.empty();
                    return optional;
                }
                JsonObject target = schemas.getJsonObject(schemaName);
                if (target == null) {
                    Optional<String> optional = Optional.empty();
                    return optional;
                }
                JsonObject resolved = this.resolveRefsAndClean(target, schemas);
                JsonObject withMeta = this.addDraft7MetaIfMissing(resolved);
                String resolvedString = withMeta.toString();
                LOG.debugf("Resolved schema '%s' for JSONForms (%d chars)", (Object)schemaName, (Object)resolvedString.length());
                Optional<String> optional = Optional.of(resolvedString);
                return optional;
            }
        }
        catch (Exception e) {
            LOG.errorf((Throwable)e, "Error resolving schema '%s' for JSONForms", (Object)schemaName);
            return Optional.empty();
        }
    }

    public Optional<String> extractParserConfigSchemaResolvedForJsonForms() {
        return this.extractSchemaResolvedForJsonForms("ParserConfig");
    }

    private JsonObject resolveRefsAndClean(JsonObject node, JsonObject componentsSchemas) {
        if (node.containsKey((Object)"$ref")) {
            String ref = node.getString("$ref", null);
            JsonObject base = this.resolveRef(ref, componentsSchemas).orElse(Json.createObjectBuilder().build());
            JsonObject resolvedBase = this.resolveRefsAndClean(base, componentsSchemas);
            JsonObjectBuilder builder = Json.createObjectBuilder();
            resolvedBase.forEach((arg_0, arg_1) -> ((JsonObjectBuilder)builder).add(arg_0, arg_1));
            for (String key : node.keySet()) {
                if ("$ref".equals(key) || key.startsWith("x-")) continue;
                JsonValue value = (JsonValue)node.get((Object)key);
                if (value instanceof JsonObject) {
                    builder.add(key, (JsonValue)this.resolveRefsAndClean((JsonObject)value, componentsSchemas));
                    continue;
                }
                if (value instanceof JsonArray) {
                    builder.add(key, (JsonValue)this.resolveArray((JsonArray)value, componentsSchemas));
                    continue;
                }
                builder.add(key, value);
            }
            return builder.build();
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (String key : node.keySet()) {
            if (key.startsWith("x-")) continue;
            JsonValue value = (JsonValue)node.get((Object)key);
            if (value instanceof JsonObject) {
                builder.add(key, (JsonValue)this.resolveRefsAndClean((JsonObject)value, componentsSchemas));
                continue;
            }
            if (value instanceof JsonArray) {
                builder.add(key, (JsonValue)this.resolveArray((JsonArray)value, componentsSchemas));
                continue;
            }
            builder.add(key, value);
        }
        return builder.build();
    }

    private JsonArray resolveArray(JsonArray array, JsonObject componentsSchemas) {
        JsonArrayBuilder ab = Json.createArrayBuilder();
        for (JsonValue v : array) {
            if (v instanceof JsonObject) {
                ab.add((JsonValue)this.resolveRefsAndClean((JsonObject)v, componentsSchemas));
                continue;
            }
            ab.add(v);
        }
        return ab.build();
    }

    private Optional<JsonObject> resolveRef(String ref, JsonObject componentsSchemas) {
        String name;
        JsonObject target;
        if (ref == null) {
            return Optional.empty();
        }
        String prefix = "#/components/schemas/";
        if (ref.startsWith("#/components/schemas/") && (target = componentsSchemas.getJsonObject(name = ref.substring("#/components/schemas/".length()))) != null) {
            return Optional.of(target);
        }
        LOG.debugf("Unsupported or unresolved $ref: %s", (Object)ref);
        return Optional.empty();
    }

    private JsonObject addDraft7MetaIfMissing(JsonObject obj) {
        if (obj.containsKey((Object)"$schema")) {
            return obj;
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("$schema", "http://json-schema.org/draft-07/schema#");
        obj.forEach((arg_0, arg_1) -> ((JsonObjectBuilder)builder).add(arg_0, arg_1));
        return builder.build();
    }

    private String cleanSchemaForJsonSchemaV7(String openApiSchema) {
        String string;
        block8: {
            JsonReader reader = Json.createReader((Reader)new StringReader(openApiSchema));
            try {
                JsonObject schema = reader.readObject();
                string = this.cleanJsonObjectForValidation(schema).toString();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.warnf((Throwable)e, "Failed to clean schema for JSON Schema v7 validation, returning original", new Object[0]);
                    return openApiSchema;
                }
            }
            reader.close();
        }
        return string;
    }

    private JsonObject cleanJsonObjectForValidation(JsonObject obj) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        obj.forEach((key, value) -> {
            if (key.startsWith("x-")) {
                return;
            }
            if ("$ref".equals(key)) {
                return;
            }
            if (value instanceof JsonObject) {
                builder.add(key, (JsonValue)this.cleanJsonObjectForValidation((JsonObject)value));
            } else if (value instanceof JsonArray) {
                JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
                ((JsonArray)value).forEach(arrayValue -> {
                    if (arrayValue instanceof JsonObject) {
                        arrayBuilder.add((JsonValue)this.cleanJsonObjectForValidation((JsonObject)arrayValue));
                    } else {
                        arrayBuilder.add(arrayValue);
                    }
                });
                builder.add(key, (JsonValue)arrayBuilder.build());
            } else {
                builder.add(key, value);
            }
        });
        return builder.build();
    }

    public Optional<String> extractSchemaForClass(Class<?> configClass) {
        String schemaName = configClass.getSimpleName();
        return this.extractSchemaByName(schemaName);
    }

    public boolean isOpenApiDocumentAvailable() {
        try {
            OpenApiDocumentService documentService = (OpenApiDocumentService)Arc.container().instance(OpenApiDocumentService.class, new Annotation[0]).get();
            if (documentService == null) {
                return false;
            }
            byte[] jsonBytes = documentService.getDocument(Format.JSON);
            return jsonBytes != null && jsonBytes.length > 0;
        }
        catch (Exception e) {
            LOG.debugf((Throwable)e, "OpenAPI document availability check failed", new Object[0]);
            return false;
        }
    }

    public Optional<String> getFullOpenApiDocument() {
        try {
            OpenApiDocumentService documentService = (OpenApiDocumentService)Arc.container().instance(OpenApiDocumentService.class, new Annotation[0]).get();
            if (documentService == null) {
                return Optional.empty();
            }
            byte[] jsonBytes = documentService.getDocument(Format.JSON);
            if (jsonBytes == null || jsonBytes.length == 0) {
                return Optional.empty();
            }
            return Optional.of(new String(jsonBytes, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LOG.errorf((Throwable)e, "Error getting full OpenAPI document", new Object[0]);
            return Optional.empty();
        }
    }
}

