/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.common.util;

import ai.pipestream.common.util.DescriptorRegistry;
import ai.pipestream.common.util.TypeConverter;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;

public class AnyHandler {
    private static final String TYPE_URL_PREFIX = "type.googleapis.com/";
    private final DescriptorRegistry descriptorRegistry;
    private final TypeConverter typeConverter;

    public AnyHandler(DescriptorRegistry descriptorRegistry) {
        this.descriptorRegistry = descriptorRegistry;
        this.typeConverter = new TypeConverter();
    }

    public AnyHandler() {
        this(new DescriptorRegistry());
    }

    public Any pack(Message message) {
        return Any.pack((Message)message);
    }

    public Message unpack(Any any) throws InvalidProtocolBufferException {
        String typeUrl = any.getTypeUrl();
        String typeName = this.extractTypeName(typeUrl);
        Descriptors.Descriptor descriptor = this.descriptorRegistry.findDescriptorByFullName(typeName);
        if (descriptor != null) {
            return DynamicMessage.parseFrom((Descriptors.Descriptor)descriptor, (ByteString)any.getValue());
        }
        throw new InvalidProtocolBufferException("Cannot unpack Any: descriptor not found for type " + typeName);
    }

    public DynamicMessage unpackToDynamic(Any any, Descriptors.Descriptor descriptor) throws InvalidProtocolBufferException {
        return DynamicMessage.parseFrom((Descriptors.Descriptor)descriptor, (ByteString)any.getValue());
    }

    public boolean is(Any any, Descriptors.Descriptor descriptor) {
        String typeUrl = any.getTypeUrl();
        String typeName = this.extractTypeName(typeUrl);
        return descriptor.getFullName().equals(typeName);
    }

    public boolean is(Any any, String fullTypeName) {
        String typeUrl = any.getTypeUrl();
        String typeName = this.extractTypeName(typeUrl);
        return fullTypeName.equals(typeName);
    }

    public String getTypeName(Any any) {
        return this.extractTypeName(any.getTypeUrl());
    }

    public String createTypeUrl(String typeName) {
        if (typeName.startsWith(TYPE_URL_PREFIX)) {
            return typeName;
        }
        return TYPE_URL_PREFIX + typeName;
    }

    private String extractTypeName(String typeUrl) {
        int lastSlash = typeUrl.lastIndexOf(47);
        if (lastSlash >= 0) {
            return typeUrl.substring(lastSlash + 1);
        }
        return typeUrl;
    }

    public Struct unpackToStruct(Any any) throws InvalidProtocolBufferException {
        Message message = this.unpack(any);
        return this.typeConverter.messageToStruct(message);
    }

    public Any packStruct(Struct struct, String typeName) {
        Descriptors.Descriptor descriptor = this.descriptorRegistry.findDescriptorByFullName(typeName);
        if (descriptor == null) {
            throw new IllegalArgumentException("Descriptor not found for type: " + typeName);
        }
        DynamicMessage message = this.typeConverter.structToMessage(struct, descriptor);
        return Any.pack((Message)message);
    }

    public Message unpackSafe(Any any) {
        try {
            return this.unpack(any);
        }
        catch (InvalidProtocolBufferException e) {
            return null;
        }
    }

    public DescriptorRegistry getDescriptorRegistry() {
        return this.descriptorRegistry;
    }
}

