/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.common.util;

import ai.pipestream.common.util.descriptor.DescriptorLoader;
import ai.pipestream.common.util.descriptor.GoogleDescriptorLoader;
import com.google.protobuf.Any;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.ListValue;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DescriptorRegistry {
    private static final Logger LOGGER = Logger.getLogger(DescriptorRegistry.class.getName());
    private final Map<String, Descriptors.Descriptor> descriptorsByFullName = new ConcurrentHashMap<String, Descriptors.Descriptor>();
    private final Map<String, Descriptors.Descriptor> descriptorsBySimpleName = new ConcurrentHashMap<String, Descriptors.Descriptor>();
    private final List<DescriptorLoader> loaders = new ArrayList<DescriptorLoader>();
    private boolean autoLoadAttempted = false;

    public DescriptorRegistry() {
        this.registerWellKnownTypes();
    }

    public DescriptorRegistry(boolean autoLoad) {
        this();
        if (autoLoad) {
            this.autoLoadDescriptors();
        }
    }

    private void registerWellKnownTypes() {
        try {
            this.register(Struct.getDescriptor());
            this.register(Value.getDescriptor());
            this.register(ListValue.getDescriptor());
            this.register(Timestamp.getDescriptor());
            this.register(Duration.getDescriptor());
            this.register(Any.getDescriptor());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void register(Descriptors.Descriptor descriptor) {
        this.descriptorsByFullName.put(descriptor.getFullName(), descriptor);
        this.descriptorsBySimpleName.put(descriptor.getName(), descriptor);
    }

    public void registerFile(Descriptors.FileDescriptor fileDescriptor) {
        for (Descriptors.Descriptor messageType : fileDescriptor.getMessageTypes()) {
            this.register(messageType);
            this.registerNestedTypes(messageType);
        }
    }

    private void registerNestedTypes(Descriptors.Descriptor descriptor) {
        for (Descriptors.Descriptor nested : descriptor.getNestedTypes()) {
            this.register(nested);
            this.registerNestedTypes(nested);
        }
    }

    public void registerFromMessage(Message message) {
        this.register(message.getDescriptorForType());
    }

    public Descriptors.Descriptor findDescriptorByFullName(String fullName) {
        return this.descriptorsByFullName.get(fullName);
    }

    public Descriptors.Descriptor findDescriptorBySimpleName(String simpleName) {
        return this.descriptorsBySimpleName.get(simpleName);
    }

    public Descriptors.Descriptor findDescriptor(String name) {
        Descriptors.Descriptor descriptor = this.findDescriptorByFullName(name);
        if (descriptor == null) {
            descriptor = this.findDescriptorBySimpleName(name);
        }
        return descriptor;
    }

    public boolean isRegistered(String fullName) {
        return this.descriptorsByFullName.containsKey(fullName);
    }

    public void clear() {
        this.descriptorsByFullName.clear();
        this.descriptorsBySimpleName.clear();
        this.registerWellKnownTypes();
    }

    public int size() {
        return this.descriptorsByFullName.size();
    }

    public void addLoader(DescriptorLoader loader) {
        if (loader != null) {
            this.loaders.add(loader);
        }
    }

    public int loadFrom(DescriptorLoader loader) throws DescriptorLoader.DescriptorLoadException {
        List<Descriptors.FileDescriptor> fileDescriptors = loader.loadDescriptors();
        int count = 0;
        for (Descriptors.FileDescriptor fd : fileDescriptors) {
            this.registerFile(fd);
            count += fd.getMessageTypes().size();
        }
        return count;
    }

    public void autoLoadDescriptors() {
        GoogleDescriptorLoader defaultLoader;
        if (this.autoLoadAttempted) {
            return;
        }
        this.autoLoadAttempted = true;
        if (this.loaders.isEmpty() && (defaultLoader = new GoogleDescriptorLoader()).isAvailable()) {
            this.loaders.add(defaultLoader);
        }
        for (DescriptorLoader loader : this.loaders) {
            if (!loader.isAvailable()) continue;
            try {
                int count = this.loadFrom(loader);
                LOGGER.log(Level.INFO, "Loaded {0} descriptors from {1}", new Object[]{count, loader.getLoaderType()});
            }
            catch (DescriptorLoader.DescriptorLoadException e) {
                LOGGER.log(Level.WARNING, "Failed to load descriptors from " + loader.getLoaderType(), e);
            }
        }
    }

    public static RegistryBuilder builder() {
        return new RegistryBuilder();
    }

    public static class RegistryBuilder {
        private final DescriptorRegistry registry = new DescriptorRegistry();

        public RegistryBuilder register(Descriptors.Descriptor descriptor) {
            this.registry.register(descriptor);
            return this;
        }

        public RegistryBuilder registerFile(Descriptors.FileDescriptor fileDescriptor) {
            this.registry.registerFile(fileDescriptor);
            return this;
        }

        public RegistryBuilder registerFromMessage(Message message) {
            this.registry.registerFromMessage(message);
            return this;
        }

        public RegistryBuilder addLoader(DescriptorLoader loader) {
            this.registry.addLoader(loader);
            return this;
        }

        public RegistryBuilder withAutoLoad() {
            this.registry.autoLoadDescriptors();
            return this;
        }

        public RegistryBuilder withGoogleDescriptorLoader() {
            this.registry.addLoader(new GoogleDescriptorLoader());
            return this;
        }

        public RegistryBuilder withGoogleDescriptorLoader(String descriptorPath) {
            this.registry.addLoader(new GoogleDescriptorLoader(descriptorPath));
            return this;
        }

        public DescriptorRegistry build() {
            return this.registry;
        }
    }
}

