/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.common.util;

import ai.pipestream.common.util.TypeConverter;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MappingHelper {
    private final TypeConverter typeConverter = new TypeConverter();

    public List<String> getAllFieldPaths(Descriptors.Descriptor descriptor, int maxDepth) {
        ArrayList<String> paths = new ArrayList<String>();
        this.collectFieldPaths(descriptor, "", 0, maxDepth, paths, new HashSet<String>());
        Collections.sort(paths);
        return paths;
    }

    public List<FieldInfo> getFieldInfos(Descriptors.Descriptor descriptor, int maxDepth) {
        ArrayList<FieldInfo> infos = new ArrayList<FieldInfo>();
        this.collectFieldInfos(descriptor, "", 0, maxDepth, infos, new HashSet<String>());
        return infos;
    }

    public ValidationResult validateRule(String rule, Descriptors.Descriptor sourceDescriptor, Descriptors.Descriptor targetDescriptor) {
        try {
            String[] parts = this.parseRule(rule);
            if (parts == null) {
                return ValidationResult.error("Invalid rule syntax: " + rule);
            }
            String targetPath = parts[0];
            String sourcePath = parts[1];
            String operation = parts[2];
            PathValidation targetValidation = this.validatePath(targetPath, targetDescriptor);
            if (!targetValidation.isValid) {
                return ValidationResult.error("Invalid target path '" + targetPath + "': " + targetValidation.error);
            }
            if (!this.isLiteral(sourcePath)) {
                boolean compatible;
                PathValidation sourceValidation = this.validatePath(sourcePath, sourceDescriptor);
                if (!sourceValidation.isValid) {
                    return ValidationResult.error("Invalid source path '" + sourcePath + "': " + sourceValidation.error);
                }
                if (operation.equals("=") && !(compatible = this.areTypesCompatible(sourceValidation.fieldDescriptor, targetValidation.fieldDescriptor))) {
                    return ValidationResult.warning("Type mismatch: " + String.valueOf(sourceValidation.fieldDescriptor.getJavaType()) + " \u2192 " + String.valueOf(targetValidation.fieldDescriptor.getJavaType()) + " (will attempt conversion)");
                }
            }
            return ValidationResult.success();
        }
        catch (Exception e) {
            return ValidationResult.error("Validation error: " + e.getMessage());
        }
    }

    public List<FieldSuggestion> suggestTargetFields(String sourcePath, Descriptors.Descriptor sourceDescriptor, Descriptors.Descriptor targetDescriptor) {
        PathValidation sourceValidation = this.validatePath(sourcePath, sourceDescriptor);
        if (!sourceValidation.isValid) {
            return Collections.emptyList();
        }
        ArrayList<FieldSuggestion> suggestions = new ArrayList<FieldSuggestion>();
        List<String> allTargetPaths = this.getAllFieldPaths(targetDescriptor, 3);
        for (String targetPath : allTargetPaths) {
            int score;
            PathValidation targetValidation = this.validatePath(targetPath, targetDescriptor);
            if (!targetValidation.isValid || (score = this.calculateCompatibilityScore(sourcePath, targetPath, sourceValidation.fieldDescriptor, targetValidation.fieldDescriptor)) <= 0) continue;
            suggestions.add(new FieldSuggestion(targetPath, score));
        }
        suggestions.sort((a, b) -> Integer.compare(b.score, a.score));
        return suggestions;
    }

    public SchemaNode exportSchema(Descriptors.Descriptor descriptor, int maxDepth) {
        return this.buildSchemaNode(descriptor, "", 0, maxDepth, new HashSet<String>());
    }

    private void collectFieldPaths(Descriptors.Descriptor descriptor, String prefix, int depth, int maxDepth, List<String> paths, Set<String> visited) {
        if (depth > maxDepth || visited.contains(descriptor.getFullName())) {
            return;
        }
        visited.add(descriptor.getFullName());
        for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
            Descriptors.Descriptor fieldType;
            String fieldPath = prefix.isEmpty() ? field.getName() : prefix + "." + field.getName();
            paths.add(fieldPath);
            if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE || field.isRepeated() || this.isTerminalType(fieldType = field.getMessageType())) continue;
            this.collectFieldPaths(fieldType, fieldPath, depth + 1, maxDepth, paths, new HashSet<String>(visited));
        }
    }

    private void collectFieldInfos(Descriptors.Descriptor descriptor, String prefix, int depth, int maxDepth, List<FieldInfo> infos, Set<String> visited) {
        if (depth > maxDepth || visited.contains(descriptor.getFullName())) {
            return;
        }
        visited.add(descriptor.getFullName());
        for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
            Descriptors.Descriptor fieldType;
            String fieldPath = prefix.isEmpty() ? field.getName() : prefix + "." + field.getName();
            FieldInfo info = new FieldInfo(fieldPath, field.getName(), field.getJavaType().name(), field.isRepeated(), field.isRequired(), field.hasDefaultValue(), depth);
            infos.add(info);
            if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE || field.isRepeated() || this.isTerminalType(fieldType = field.getMessageType())) continue;
            this.collectFieldInfos(fieldType, fieldPath, depth + 1, maxDepth, infos, new HashSet<String>(visited));
        }
    }

    private SchemaNode buildSchemaNode(Descriptors.Descriptor descriptor, String path, int depth, int maxDepth, Set<String> visited) {
        String fieldName = path.isEmpty() ? descriptor.getName() : (path.contains(".") ? path.substring(path.lastIndexOf(".") + 1) : path);
        SchemaNode node = new SchemaNode(fieldName, path, "MESSAGE");
        if (depth > maxDepth || visited.contains(descriptor.getFullName())) {
            return node;
        }
        visited.add(descriptor.getFullName());
        for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
            String fieldPath;
            String string = fieldPath = path.isEmpty() ? field.getName() : path + "." + field.getName();
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE && !field.isRepeated()) {
                Descriptors.Descriptor fieldType = field.getMessageType();
                if (!this.isTerminalType(fieldType)) {
                    SchemaNode childNode = this.buildSchemaNode(fieldType, fieldPath, depth + 1, maxDepth, new HashSet<String>(visited));
                    childNode.repeated = field.isRepeated();
                    node.children.add(childNode);
                    continue;
                }
                node.children.add(new SchemaNode(field.getName(), fieldPath, field.getJavaType().name(), field.isRepeated()));
                continue;
            }
            node.children.add(new SchemaNode(field.getName(), fieldPath, field.getJavaType().name(), field.isRepeated()));
        }
        return node;
    }

    private PathValidation validatePath(String path, Descriptors.Descriptor descriptor) {
        try {
            String[] parts = path.split("\\.");
            Descriptors.Descriptor currentDescriptor = descriptor;
            Descriptors.FieldDescriptor lastField = null;
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                Descriptors.FieldDescriptor field = currentDescriptor.findFieldByName(part);
                if (field == null) {
                    return new PathValidation(false, "Field '" + part + "' not found in " + currentDescriptor.getName(), null);
                }
                lastField = field;
                if (i >= parts.length - 1) continue;
                if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                    return new PathValidation(false, "Field '" + part + "' is not a message type", null);
                }
                if (field.isRepeated()) {
                    return new PathValidation(false, "Cannot traverse through repeated field '" + part + "'", null);
                }
                currentDescriptor = field.getMessageType();
            }
            return new PathValidation(true, null, lastField);
        }
        catch (Exception e) {
            return new PathValidation(false, e.getMessage(), null);
        }
    }

    private boolean areTypesCompatible(Descriptors.FieldDescriptor source, Descriptors.FieldDescriptor target) {
        if (source.getJavaType() == target.getJavaType()) {
            return true;
        }
        EnumSet<Descriptors.FieldDescriptor.JavaType> numericTypes = EnumSet.of(Descriptors.FieldDescriptor.JavaType.INT, Descriptors.FieldDescriptor.JavaType.LONG, Descriptors.FieldDescriptor.JavaType.FLOAT, Descriptors.FieldDescriptor.JavaType.DOUBLE);
        if (numericTypes.contains(source.getJavaType()) && numericTypes.contains(target.getJavaType())) {
            return true;
        }
        return source.getJavaType() == Descriptors.FieldDescriptor.JavaType.STRING || target.getJavaType() == Descriptors.FieldDescriptor.JavaType.STRING;
    }

    private int calculateCompatibilityScore(String sourcePath, String targetPath, Descriptors.FieldDescriptor sourceField, Descriptors.FieldDescriptor targetField) {
        int score = 0;
        if (sourceField.getJavaType() == targetField.getJavaType()) {
            score += 100;
        } else if (this.areTypesCompatible(sourceField, targetField)) {
            score += 50;
        } else {
            return 0;
        }
        String sourceName = sourcePath.substring(sourcePath.lastIndexOf(46) + 1);
        String targetName = targetPath.substring(targetPath.lastIndexOf(46) + 1);
        if (sourceName.equalsIgnoreCase(targetName)) {
            score += 50;
        } else if (sourceName.toLowerCase().contains(targetName.toLowerCase()) || targetName.toLowerCase().contains(sourceName.toLowerCase())) {
            score += 25;
        }
        if (sourceField.isRepeated() == targetField.isRepeated()) {
            score += 20;
        }
        return score;
    }

    private String[] parseRule(String rule) {
        if (rule.contains("=") && !rule.contains("+=")) {
            String[] parts = rule.split("=", 2);
            if (parts.length == 2) {
                return new String[]{parts[0].trim(), parts[1].trim(), "="};
            }
        } else if (rule.contains("+=")) {
            String[] parts = rule.split("\\+=", 2);
            if (parts.length == 2) {
                return new String[]{parts[0].trim(), parts[1].trim(), "+="};
            }
        } else if (rule.trim().startsWith("-")) {
            String target = rule.trim().substring(1).trim();
            return new String[]{target, null, "-"};
        }
        return null;
    }

    private boolean isLiteral(String value) {
        return (value = value.trim()).equals("null") || value.equals("true") || value.equals("false") || value.startsWith("\"") && value.endsWith("\"") || value.matches("-?\\d+(\\.\\d+)?");
    }

    private boolean isTerminalType(Descriptors.Descriptor descriptor) {
        String fullName = descriptor.getFullName();
        return fullName.startsWith("google.protobuf.") && (fullName.equals("google.protobuf.Struct") || fullName.equals("google.protobuf.Value") || fullName.equals("google.protobuf.Any") || fullName.equals("google.protobuf.Timestamp") || fullName.equals("google.protobuf.Duration"));
    }

    public static class ValidationResult {
        public final boolean isValid;
        public final String message;
        public final ValidationLevel level;

        private ValidationResult(boolean isValid, String message, ValidationLevel level) {
            this.isValid = isValid;
            this.message = message;
            this.level = level;
        }

        public static ValidationResult success() {
            return new ValidationResult(true, "Valid", ValidationLevel.SUCCESS);
        }

        public static ValidationResult error(String message) {
            return new ValidationResult(false, message, ValidationLevel.ERROR);
        }

        public static ValidationResult warning(String message) {
            return new ValidationResult(true, message, ValidationLevel.WARNING);
        }

        public static enum ValidationLevel {
            SUCCESS,
            WARNING,
            ERROR;

        }
    }

    private static class PathValidation {
        final boolean isValid;
        final String error;
        final Descriptors.FieldDescriptor fieldDescriptor;

        PathValidation(boolean isValid, String error, Descriptors.FieldDescriptor fieldDescriptor) {
            this.isValid = isValid;
            this.error = error;
            this.fieldDescriptor = fieldDescriptor;
        }
    }

    public static class FieldSuggestion {
        public final String fieldPath;
        public final int score;

        public FieldSuggestion(String fieldPath, int score) {
            this.fieldPath = fieldPath;
            this.score = score;
        }
    }

    public static class SchemaNode {
        public final String name;
        public final String path;
        public final String type;
        public boolean repeated;
        public final List<SchemaNode> children = new ArrayList<SchemaNode>();

        public SchemaNode(String name, String path, String type) {
            this(name, path, type, false);
        }

        public SchemaNode(String name, String path, String type, boolean repeated) {
            this.name = name;
            this.path = path;
            this.type = type;
            this.repeated = repeated;
        }
    }

    public static class FieldInfo {
        public final String path;
        public final String name;
        public final String type;
        public final boolean repeated;
        public final boolean required;
        public final boolean hasDefault;
        public final int depth;

        public FieldInfo(String path, String name, String type, boolean repeated, boolean required, boolean hasDefault, int depth) {
            this.path = path;
            this.name = name;
            this.type = type;
            this.repeated = repeated;
            this.required = required;
            this.hasDefault = hasDefault;
            this.depth = depth;
        }
    }
}

