/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.common.util;

import ai.pipestream.common.util.MappingHelper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;

public class MappingHelperJsonSupport {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public String fieldsToJson(List<MappingHelper.FieldInfo> fields) {
        try {
            ArrayNode array = this.objectMapper.createArrayNode();
            for (MappingHelper.FieldInfo field : fields) {
                ObjectNode node = this.objectMapper.createObjectNode();
                node.put("path", field.path);
                node.put("name", field.name);
                node.put("type", field.type);
                node.put("repeated", field.repeated);
                node.put("required", field.required);
                node.put("hasDefault", field.hasDefault);
                node.put("depth", field.depth);
                array.add((JsonNode)node);
            }
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)array);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize fields to JSON", e);
        }
    }

    public String schemaToJson(MappingHelper.SchemaNode schema) {
        try {
            ObjectNode node = this.schemaNodeToJson(schema);
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize schema to JSON", e);
        }
    }

    public String suggestionsToJson(List<MappingHelper.FieldSuggestion> suggestions) {
        try {
            ArrayNode array = this.objectMapper.createArrayNode();
            for (MappingHelper.FieldSuggestion suggestion : suggestions) {
                ObjectNode node = this.objectMapper.createObjectNode();
                node.put("fieldPath", suggestion.fieldPath);
                node.put("score", suggestion.score);
                array.add((JsonNode)node);
            }
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)array);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize suggestions to JSON", e);
        }
    }

    public String validationToJson(MappingHelper.ValidationResult result) {
        try {
            ObjectNode node = this.objectMapper.createObjectNode();
            node.put("valid", result.isValid);
            node.put("message", result.message);
            node.put("level", result.level.name());
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize validation to JSON", e);
        }
    }

    private ObjectNode schemaNodeToJson(MappingHelper.SchemaNode node) {
        ObjectNode json = this.objectMapper.createObjectNode();
        json.put("name", node.name);
        json.put("path", node.path);
        json.put("type", node.type);
        json.put("repeated", node.repeated);
        if (!node.children.isEmpty()) {
            ArrayNode children = this.objectMapper.createArrayNode();
            for (MappingHelper.SchemaNode child : node.children) {
                children.add((JsonNode)this.schemaNodeToJson(child));
            }
            json.set("children", (JsonNode)children);
        }
        return json;
    }
}

