/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.common.util;

import ai.pipestream.common.util.ProcessingBuffer;
import com.google.protobuf.Message;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.logging.Logger;

public class ProcessingBufferImpl<T extends Message>
implements ProcessingBuffer<T> {
    private static final Logger LOG = Logger.getLogger(ProcessingBufferImpl.class);
    private static final String DEFAULT_PREFIX = "protobuf";
    private static final int DEFAULT_PRECISION = 3;
    private static final int MAX_PRECISION = 6;
    private final LinkedBlockingDeque<T> buffer;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final int capacity;
    private final Class<T> messageClass;
    private final FileSystem fileSystem;
    private final Path defaultLocation;
    private final Path saveLocation;
    private final String savePrefix;
    private final int savePrecision;

    public ProcessingBufferImpl(int capacity, Class<T> messageClass, FileSystem fileSystem, Path saveLocation, String savePrefix, int savePrecision) {
        this.capacity = capacity;
        this.buffer = new LinkedBlockingDeque(capacity);
        this.messageClass = messageClass;
        this.fileSystem = fileSystem;
        this.defaultLocation = fileSystem.getPath("./", new String[0]);
        this.saveLocation = saveLocation != null ? saveLocation : this.defaultLocation;
        this.savePrefix = savePrefix != null ? savePrefix : DEFAULT_PREFIX;
        this.savePrecision = Math.max(1, Math.min(savePrecision, 6));
    }

    public ProcessingBufferImpl(int capacity, Class<T> messageClass, Path saveLocation, String savePrefix, int savePrecision) {
        this(capacity, messageClass, FileSystems.getDefault(), saveLocation, savePrefix, savePrecision);
    }

    public ProcessingBufferImpl(int capacity, Class<T> messageClass, FileSystem fileSystem) {
        this(capacity, messageClass, fileSystem, fileSystem.getPath("./", new String[0]), DEFAULT_PREFIX, 3);
    }

    public ProcessingBufferImpl(int capacity, Class<T> messageClass) {
        this(capacity, messageClass, FileSystems.getDefault(), FileSystems.getDefault().getPath("./", new String[0]), DEFAULT_PREFIX, 3);
    }

    @PreDestroy
    public void saveOnShutdown() {
        if (this.buffer.isEmpty()) {
            LOG.debug((Object)"Buffer is empty, nothing to save on shutdown");
            return;
        }
        Path location = this.saveLocation != null ? this.saveLocation : this.defaultLocation;
        LOG.info((Object)("Saving " + this.buffer.size() + " messages from buffer to " + String.valueOf(location) + " during shutdown"));
        this.saveToDisk(location, this.savePrefix, this.savePrecision);
    }

    @Override
    public void add(T message) {
        if (message == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            Message clonedMessage = message.toBuilder().build();
            if (this.buffer.size() >= this.capacity) {
                this.buffer.pollFirst();
            }
            this.buffer.offerLast(clonedMessage);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void saveToDisk() {
        this.saveToDisk(this.defaultLocation, DEFAULT_PREFIX, 3);
    }

    @Override
    public void saveToDisk(String prefix, int numberPrecision) {
        this.saveToDisk(this.defaultLocation, prefix, numberPrecision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveToDisk(Path location, String fileNamePrefix, int numberPrecision) {
        if (location == null) {
            location = this.defaultLocation;
        }
        if (fileNamePrefix == null || fileNamePrefix.isEmpty()) {
            fileNamePrefix = DEFAULT_PREFIX;
        }
        numberPrecision = Math.max(1, Math.min(numberPrecision, 6));
        this.lock.readLock().lock();
        try {
            if (!Files.exists(location, new LinkOption[0])) {
                try {
                    Files.createDirectories(location, new FileAttribute[0]);
                }
                catch (IOException e) {
                    LOG.error((Object)("Failed to create directory: " + String.valueOf(location) + ": " + e.getMessage()));
                    this.lock.readLock().unlock();
                    return;
                }
            }
            ArrayList<T> messages = new ArrayList<T>(this.buffer);
            for (int i = 0; i < messages.size(); ++i) {
                Message message = (Message)messages.get(i);
                String fileName = String.format("%s-%0" + numberPrecision + "d.bin", fileNamePrefix, i);
                Path filePath = location.resolve(fileName);
                try {
                    try (OutputStream os = Files.newOutputStream(filePath, new OpenOption[0]);){
                        message.writeTo(os);
                    }
                    LOG.debug((Object)("Saved protobuf to " + String.valueOf(filePath)));
                    continue;
                }
                catch (IOException e) {
                    LOG.error((Object)("Failed to save protobuf to " + String.valueOf(filePath) + ": " + e.getMessage()));
                }
            }
            LOG.info((Object)("Saved " + messages.size() + " protobufs to " + String.valueOf(location)));
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.buffer.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.buffer.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public List<T> snapshot() {
        this.lock.readLock().lock();
        try {
            ArrayList<T> arrayList = new ArrayList<T>(this.buffer);
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

