/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.common.util;

import ai.pipestream.common.util.AnyHandler;
import ai.pipestream.common.util.DescriptorRegistry;
import ai.pipestream.common.util.ProtoFieldMapper;
import ai.pipestream.common.util.TypeConverter;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ListValue;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import jakarta.enterprise.context.ApplicationScoped;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@ApplicationScoped
public class ProtoFieldMapperImpl
implements ProtoFieldMapper {
    private final RuleParser ruleParser = new RuleParser();
    private final FieldAccessor fieldAccessor;
    private final DescriptorRegistry descriptorRegistry;
    private final AnyHandler anyHandler;
    private final TypeConverter typeConverter;

    public ProtoFieldMapperImpl() {
        this.descriptorRegistry = new DescriptorRegistry();
        this.anyHandler = new AnyHandler(this.descriptorRegistry);
        this.typeConverter = new TypeConverter();
        this.fieldAccessor = new FieldAccessor(this.anyHandler, this.typeConverter);
    }

    public ProtoFieldMapperImpl(DescriptorRegistry descriptorRegistry) {
        this.descriptorRegistry = descriptorRegistry;
        this.anyHandler = new AnyHandler(descriptorRegistry);
        this.typeConverter = new TypeConverter();
        this.fieldAccessor = new FieldAccessor(this.anyHandler, this.typeConverter);
    }

    @Override
    public DescriptorRegistry getDescriptorRegistry() {
        return this.descriptorRegistry;
    }

    @Override
    public AnyHandler getAnyHandler() {
        return this.anyHandler;
    }

    public static ProtoFieldMapper withAutoLoad() {
        DescriptorRegistry registry = new DescriptorRegistry(true);
        return new ProtoFieldMapperImpl(registry);
    }

    @Override
    public void map(Message source, Message.Builder targetBuilder, List<String> rules) throws MappingException {
        List<MappingRule> parsedRules = this.ruleParser.parse(rules);
        for (MappingRule rule : parsedRules) {
            try {
                Object value = null;
                if (rule.sourcePath != null) {
                    value = this.fieldAccessor.getValue((MessageOrBuilder)source, rule.sourcePath, rule.originalRule);
                }
                switch (rule.operation.ordinal()) {
                    case 0: {
                        this.fieldAccessor.setValue(targetBuilder, rule.targetPath, value, rule.originalRule);
                        break;
                    }
                    case 1: {
                        this.fieldAccessor.appendValue(targetBuilder, rule.targetPath, value, rule.originalRule);
                        break;
                    }
                    case 2: {
                        this.fieldAccessor.clearField(targetBuilder, rule.targetPath, rule.originalRule);
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof MappingException) {
                    throw e;
                }
                throw new MappingException("Failed to execute rule: " + rule.originalRule, e, rule.originalRule);
            }
        }
    }

    private static class RuleParser {
        private static final Pattern ASSIGN_PATTERN = Pattern.compile("^\\s*([^=\\s]+)\\s*=\\s*(.+)\\s*$");
        private static final Pattern APPEND_PATTERN = Pattern.compile("^\\s*([^+\\s]+)\\s*\\+=\\s*(.+)\\s*$");
        private static final Pattern CLEAR_PATTERN = Pattern.compile("^\\s*-\\s*(\\S+)\\s*$");

        private RuleParser() {
        }

        public List<MappingRule> parse(List<String> ruleStrings) throws MappingException {
            ArrayList<MappingRule> rules = new ArrayList<MappingRule>();
            for (String ruleString : ruleStrings) {
                if (ruleString == null || ruleString.trim().isEmpty()) continue;
                Matcher assignMatcher = ASSIGN_PATTERN.matcher(ruleString);
                if (assignMatcher.matches()) {
                    rules.add(new MappingRule(assignMatcher.group(1), assignMatcher.group(2), Operation.ASSIGN, ruleString));
                    continue;
                }
                Matcher appendMatcher = APPEND_PATTERN.matcher(ruleString);
                if (appendMatcher.matches()) {
                    rules.add(new MappingRule(appendMatcher.group(1), appendMatcher.group(2), Operation.APPEND, ruleString));
                    continue;
                }
                Matcher clearMatcher = CLEAR_PATTERN.matcher(ruleString);
                if (clearMatcher.matches()) {
                    rules.add(new MappingRule(clearMatcher.group(1), null, Operation.CLEAR, ruleString));
                    continue;
                }
                throw new MappingException("Invalid rule syntax", ruleString);
            }
            return rules;
        }
    }

    static class FieldAccessor {
        private static final String PATH_SEPARATOR_REGEX = "\\.";
        private final AnyHandler anyHandler;
        private final TypeConverter typeConverter;

        public FieldAccessor(AnyHandler anyHandler, TypeConverter typeConverter) {
            this.anyHandler = anyHandler;
            this.typeConverter = typeConverter;
        }

        public Object getValue(MessageOrBuilder root, String path, String rule) throws MappingException {
            String trimmedPath;
            switch (trimmedPath = path.trim()) {
                case "null": {
                    return null;
                }
                case "true": {
                    return true;
                }
                case "false": {
                    return false;
                }
            }
            if (trimmedPath.startsWith("\"") && trimmedPath.endsWith("\"")) {
                if (trimmedPath.length() == 1) {
                    throw new MappingException("Invalid empty quoted string literal", rule);
                }
                return trimmedPath.substring(1, trimmedPath.length() - 1);
            }
            try {
                if (!trimmedPath.contains(" ") && (trimmedPath.matches("-?\\d+\\.\\d+") || trimmedPath.matches("-?\\d+"))) {
                    if (trimmedPath.contains(".")) {
                        return Double.parseDouble(trimmedPath);
                    }
                    return Long.parseLong(trimmedPath);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String[] parts = trimmedPath.split(PATH_SEPARATOR_REGEX);
            Object current = root;
            block21: for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                MessageOrBuilder messageOrBuilder = current;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Struct.class, MessageOrBuilder.class}, (Object)messageOrBuilder, n)) {
                    case -1: {
                        throw new MappingException("Cannot resolve path '" + path + "': intermediate value is null at segment '" + part + "'", rule);
                    }
                    case 0: {
                        Struct struct = (Struct)messageOrBuilder;
                        Value value = (Value)struct.getFieldsMap().get(part);
                        if (value == null && i < parts.length - 1) {
                            throw new MappingException("Cannot resolve path '" + path + "': key '" + part + "' not found in struct", rule);
                        }
                        current = this.unwrapValue(value);
                        continue block21;
                    }
                    case 1: {
                        Object fieldValue;
                        MessageOrBuilder currentMsg = messageOrBuilder;
                        Descriptors.FieldDescriptor fd = this.findField(currentMsg.getDescriptorForType(), part, rule);
                        if (i == parts.length - 1) {
                            if (!fd.isRepeated() && !currentMsg.hasField(fd)) {
                                return null;
                            }
                            fieldValue = currentMsg.getField(fd);
                            if (fieldValue instanceof Any) {
                                try {
                                    return this.anyHandler.unpack((Any)fieldValue);
                                }
                                catch (InvalidProtocolBufferException e) {
                                    return fieldValue;
                                }
                            }
                            return fieldValue;
                        }
                        if (fd.isRepeated() || fd.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                            throw new MappingException("Path '" + path + "' attempts to traverse through non-message or repeated field '" + part + "'", rule);
                        }
                        if (!currentMsg.hasField(fd)) {
                            throw new MappingException("Path '" + path + "' is invalid because intermediate field '" + part + "' is not set.", rule);
                        }
                        fieldValue = currentMsg.getField(fd);
                        if (fieldValue instanceof Any) {
                            try {
                                current = this.anyHandler.unpack((Any)fieldValue);
                                continue block21;
                            }
                            catch (InvalidProtocolBufferException e) {
                                throw new MappingException("Failed to unpack Any field '" + part + "' during path traversal", e, rule);
                            }
                        }
                        current = fieldValue;
                        continue block21;
                    }
                    default: {
                        throw new MappingException("Cannot resolve path '" + path + "': tried to traverse through a non-message, non-struct value at '" + part + "'", rule);
                    }
                }
            }
            return current;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValue(Message.Builder root, String path, Object value, String rule) throws MappingException {
            PathResolutionResult result = this.resolvePathToFinalContainer(root, path, rule);
            String fieldName = result.finalPathPart;
            Message.Builder containerBuilder = (Message.Builder)result.container;
            if (containerBuilder.getDescriptorForType().getFullName().equals(Struct.getDescriptor().getFullName())) {
                try {
                    Struct currentStruct = Struct.parseFrom((ByteString)containerBuilder.build().toByteString());
                    Struct.Builder modifiedStructBuilder = currentStruct.toBuilder();
                    modifiedStructBuilder.putFields(fieldName, this.wrapValue(value));
                    containerBuilder.clear().mergeFrom((Message)modifiedStructBuilder.build());
                    return;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new MappingException("Failed to rebuild struct for setting value", e, rule);
                }
            } else {
                Descriptors.FieldDescriptor fd = this.findField(containerBuilder.getDescriptorForType(), fieldName, rule);
                if (fd.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE && fd.getMessageType().getFullName().equals(Any.getDescriptor().getFullName())) {
                    if (value instanceof Any) {
                        containerBuilder.setField(fd, value);
                        return;
                    } else {
                        if (!(value instanceof Message)) throw new MappingException("Cannot pack non-Message value into Any field: " + fieldName, rule);
                        Any packedAny = this.anyHandler.pack((Message)value);
                        containerBuilder.setField(fd, (Object)packedAny);
                    }
                    return;
                } else {
                    Object convertedValue = this.typeConverter.convertToFieldType(value, fd);
                    containerBuilder.setField(fd, convertedValue);
                }
            }
        }

        public void appendValue(Message.Builder root, String path, Object value, String rule) throws MappingException {
            PathResolutionResult result = this.resolvePathToFinalContainer(root, path, rule);
            Object object = result.container;
            if (!(object instanceof Message.Builder)) {
                throw new MappingException("Cannot append to a non-message field", rule);
            }
            Message.Builder finalBuilder = (Message.Builder)object;
            Descriptors.FieldDescriptor fd = this.findField(finalBuilder.getDescriptorForType(), result.finalPathPart, rule);
            if (!fd.isRepeated()) {
                throw new MappingException("Cannot append: field '" + fd.getName() + "' is not repeated", rule);
            }
            if (value instanceof List) {
                for (Object item : (List)value) {
                    finalBuilder.addRepeatedField(fd, item);
                }
            } else {
                finalBuilder.addRepeatedField(fd, value);
            }
        }

        public void clearField(Message.Builder root, String path, String rule) throws MappingException {
            PathResolutionResult result = this.resolvePathToFinalContainer(root, path, rule);
            String fieldName = result.finalPathPart;
            Message.Builder containerBuilder = (Message.Builder)result.container;
            if (containerBuilder.getDescriptorForType().getFullName().equals(Struct.getDescriptor().getFullName())) {
                try {
                    Struct currentStruct = Struct.parseFrom((ByteString)containerBuilder.build().toByteString());
                    Struct.Builder modifiedStructBuilder = currentStruct.toBuilder();
                    modifiedStructBuilder.removeFields(fieldName);
                    containerBuilder.clear().mergeFrom((Message)modifiedStructBuilder.build());
                }
                catch (InvalidProtocolBufferException e) {
                    throw new MappingException("Failed to rebuild struct for clearing field", e, rule);
                }
            } else {
                Descriptors.FieldDescriptor fd = this.findField(containerBuilder.getDescriptorForType(), fieldName, rule);
                containerBuilder.clearField(fd);
            }
        }

        private PathResolutionResult resolvePathToFinalContainer(Message.Builder root, String path, String rule) throws MappingException {
            String[] parts = path.split(PATH_SEPARATOR_REGEX);
            Message.Builder currentBuilder = root;
            for (int i = 0; i < parts.length - 1; ++i) {
                String part = parts[i];
                Descriptors.FieldDescriptor fd = this.findField(currentBuilder.getDescriptorForType(), part, rule);
                if (fd.isRepeated() || fd.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                    throw new MappingException("Path '" + path + "' attempts to traverse through non-singular message field '" + part + "'", rule);
                }
                currentBuilder = currentBuilder.getFieldBuilder(fd);
            }
            return new PathResolutionResult(currentBuilder, parts[parts.length - 1]);
        }

        private Descriptors.FieldDescriptor findField(Descriptors.Descriptor d, String name, String fullPath) throws MappingException {
            Descriptors.FieldDescriptor fd = d.findFieldByName(name);
            if (fd == null) {
                throw new MappingException("Field '" + name + "' not found in message '" + d.getName() + "'", fullPath);
            }
            return fd;
        }

        private Value wrapValue(Object value) {
            Object object = value;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Double.class, Float.class, Number.class, Boolean.class, Struct.class, List.class}, (Object)object, n)) {
                case -1: {
                    return Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
                }
                case 0: {
                    String s = (String)object;
                    return Value.newBuilder().setStringValue(s).build();
                }
                case 1: {
                    Double v = (Double)object;
                    return Value.newBuilder().setNumberValue(v.doubleValue()).build();
                }
                case 2: {
                    Float v = (Float)object;
                    return Value.newBuilder().setNumberValue(v.doubleValue()).build();
                }
                case 3: {
                    Number number = (Number)object;
                    return Value.newBuilder().setNumberValue(number.doubleValue()).build();
                }
                case 4: {
                    Boolean b = (Boolean)object;
                    return Value.newBuilder().setBoolValue(b.booleanValue()).build();
                }
                case 5: {
                    Struct struct = (Struct)object;
                    return Value.newBuilder().setStructValue(struct).build();
                }
                case 6: {
                    List list = (List)object;
                    ListValue.Builder listBuilder = ListValue.newBuilder();
                    for (Object item : list) {
                        listBuilder.addValues(this.wrapValue(item));
                    }
                    return Value.newBuilder().setListValue(listBuilder).build();
                }
            }
            throw new IllegalArgumentException("Cannot wrap unsupported type to Protobuf Value: " + value.getClass().getName());
        }

        private Object unwrapValue(Value value) {
            if (value == null || value.getKindCase() == Value.KindCase.NULL_VALUE) {
                return null;
            }
            return switch (value.getKindCase()) {
                case Value.KindCase.NUMBER_VALUE -> value.getNumberValue();
                case Value.KindCase.STRING_VALUE -> value.getStringValue();
                case Value.KindCase.BOOL_VALUE -> value.getBoolValue();
                case Value.KindCase.STRUCT_VALUE -> value.getStructValue();
                case Value.KindCase.LIST_VALUE -> value.getListValue().getValuesList().stream().map(this::unwrapValue).collect(Collectors.toList());
                default -> null;
            };
        }

        private static class PathResolutionResult {
            final Object container;
            final String finalPathPart;

            PathResolutionResult(Object container, String finalPathPart) {
                this.container = container;
                this.finalPathPart = finalPathPart;
            }
        }
    }

    private static class MappingRule {
        final String targetPath;
        final String sourcePath;
        final Operation operation;
        final String originalRule;

        MappingRule(String targetPath, String sourcePath, Operation operation, String originalRule) {
            this.targetPath = targetPath;
            this.sourcePath = sourcePath;
            this.operation = operation;
            this.originalRule = originalRule;
        }
    }

    private static enum Operation {
        ASSIGN,
        APPEND,
        CLEAR;

    }

    public static class MappingException
    extends Exception {
        public MappingException(String message, String rule) {
            super(message + (String)(rule != null ? " (Rule: '" + rule + "')" : ""));
        }

        public MappingException(String message, Throwable cause, String rule) {
            super(message + (String)(rule != null ? " (Rule: '" + rule + "')" : ""), cause);
        }
    }
}

