/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.common.util;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.ListValue;
import com.google.protobuf.Message;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TypeConverter {
    public Value toValue(Object value) {
        Object object = value;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Double.class, Float.class, Number.class, Boolean.class, Struct.class, List.class, Message.class}, (Object)object, n)) {
            case -1: {
                return Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
            }
            case 0: {
                String s = (String)object;
                return Value.newBuilder().setStringValue(s).build();
            }
            case 1: {
                Double v = (Double)object;
                return Value.newBuilder().setNumberValue(v.doubleValue()).build();
            }
            case 2: {
                Float v = (Float)object;
                return Value.newBuilder().setNumberValue(v.doubleValue()).build();
            }
            case 3: {
                Number number = (Number)object;
                return Value.newBuilder().setNumberValue(number.doubleValue()).build();
            }
            case 4: {
                Boolean b = (Boolean)object;
                return Value.newBuilder().setBoolValue(b.booleanValue()).build();
            }
            case 5: {
                Struct struct = (Struct)object;
                return Value.newBuilder().setStructValue(struct).build();
            }
            case 6: {
                List list = (List)object;
                ListValue.Builder listBuilder = ListValue.newBuilder();
                for (Object item : list) {
                    listBuilder.addValues(this.toValue(item));
                }
                return Value.newBuilder().setListValue(listBuilder).build();
            }
            case 7: {
                Message message = (Message)object;
                return Value.newBuilder().setStructValue(this.messageToStruct(message)).build();
            }
        }
        throw new IllegalArgumentException("Cannot convert type to Value: " + value.getClass().getName());
    }

    public Object fromValue(Value value) {
        if (value == null || value.getKindCase() == Value.KindCase.NULL_VALUE) {
            return null;
        }
        return switch (value.getKindCase()) {
            case Value.KindCase.NUMBER_VALUE -> value.getNumberValue();
            case Value.KindCase.STRING_VALUE -> value.getStringValue();
            case Value.KindCase.BOOL_VALUE -> value.getBoolValue();
            case Value.KindCase.STRUCT_VALUE -> value.getStructValue();
            case Value.KindCase.LIST_VALUE -> value.getListValue().getValuesList().stream().map(this::fromValue).collect(Collectors.toList());
            default -> null;
        };
    }

    public Struct messageToStruct(Message message) {
        Struct.Builder structBuilder = Struct.newBuilder();
        Descriptors.Descriptor descriptor = message.getDescriptorForType();
        for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
            if (!field.isRepeated() && !message.hasField(field)) continue;
            String fieldName = field.getName();
            Object fieldValue = message.getField(field);
            if (field.isRepeated()) {
                List values = (List)fieldValue;
                if (values.isEmpty()) continue;
                ListValue.Builder listBuilder = ListValue.newBuilder();
                for (Object item : values) {
                    listBuilder.addValues(this.fieldToValue(field, item));
                }
                structBuilder.putFields(fieldName, Value.newBuilder().setListValue(listBuilder).build());
                continue;
            }
            structBuilder.putFields(fieldName, this.fieldToValue(field, fieldValue));
        }
        return structBuilder.build();
    }

    public DynamicMessage structToMessage(Struct struct, Descriptors.Descriptor descriptor) {
        DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        for (Map.Entry entry : struct.getFieldsMap().entrySet()) {
            Object convertedValue;
            Descriptors.FieldDescriptor field = descriptor.findFieldByName((String)entry.getKey());
            if (field == null || (convertedValue = this.valueToField((Value)entry.getValue(), field)) == null) continue;
            if (field.isRepeated() && convertedValue instanceof List) {
                for (Object item : (List)convertedValue) {
                    builder.addRepeatedField(field, item);
                }
                continue;
            }
            builder.setField(field, convertedValue);
        }
        return builder.build();
    }

    private Value fieldToValue(Descriptors.FieldDescriptor field, Object value) {
        if (value == null) {
            return Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
        }
        return switch (field.getJavaType()) {
            case Descriptors.FieldDescriptor.JavaType.INT, Descriptors.FieldDescriptor.JavaType.LONG, Descriptors.FieldDescriptor.JavaType.FLOAT, Descriptors.FieldDescriptor.JavaType.DOUBLE -> Value.newBuilder().setNumberValue(((Number)value).doubleValue()).build();
            case Descriptors.FieldDescriptor.JavaType.BOOLEAN -> Value.newBuilder().setBoolValue(((Boolean)value).booleanValue()).build();
            case Descriptors.FieldDescriptor.JavaType.STRING -> Value.newBuilder().setStringValue((String)value).build();
            case Descriptors.FieldDescriptor.JavaType.ENUM -> {
                Descriptors.EnumValueDescriptor enumValue = (Descriptors.EnumValueDescriptor)value;
                yield Value.newBuilder().setStringValue(enumValue.getName()).build();
            }
            case Descriptors.FieldDescriptor.JavaType.MESSAGE -> {
                if (value instanceof Struct) {
                    yield Value.newBuilder().setStructValue((Struct)value).build();
                }
                yield Value.newBuilder().setStructValue(this.messageToStruct((Message)value)).build();
            }
            case Descriptors.FieldDescriptor.JavaType.BYTE_STRING -> {
                ByteString bytes = (ByteString)value;
                yield Value.newBuilder().setStringValue(bytes.toStringUtf8()).build();
            }
            default -> Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
        };
    }

    private Object valueToField(Value value, Descriptors.FieldDescriptor field) {
        if (value.getKindCase() == Value.KindCase.NULL_VALUE) {
            return null;
        }
        switch (field.getJavaType()) {
            case INT: {
                return (int)value.getNumberValue();
            }
            case LONG: {
                return (long)value.getNumberValue();
            }
            case FLOAT: {
                return Float.valueOf((float)value.getNumberValue());
            }
            case DOUBLE: {
                return value.getNumberValue();
            }
            case BOOLEAN: {
                return value.getBoolValue();
            }
            case STRING: {
                return value.getStringValue();
            }
            case ENUM: {
                Descriptors.EnumDescriptor enumDescriptor = field.getEnumType();
                return enumDescriptor.findValueByName(value.getStringValue());
            }
            case MESSAGE: {
                if (field.getMessageType().getFullName().equals(Struct.getDescriptor().getFullName())) {
                    return value.getStructValue();
                }
                if (value.getKindCase() == Value.KindCase.STRUCT_VALUE) {
                    return this.structToMessage(value.getStructValue(), field.getMessageType());
                }
                return null;
            }
            case BYTE_STRING: {
                return ByteString.copyFromUtf8((String)value.getStringValue());
            }
        }
        return null;
    }

    public Object convertToFieldType(Object value, Descriptors.FieldDescriptor field) {
        if (value == null) {
            return null;
        }
        if (this.isCompatibleType(value, field)) {
            return value;
        }
        switch (field.getJavaType()) {
            case INT: {
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                if (!(value instanceof String)) break;
                return Integer.parseInt((String)value);
            }
            case LONG: {
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                if (!(value instanceof String)) break;
                return Long.parseLong((String)value);
            }
            case FLOAT: {
                if (value instanceof Number) {
                    return Float.valueOf(((Number)value).floatValue());
                }
                if (!(value instanceof String)) break;
                return Float.valueOf(Float.parseFloat((String)value));
            }
            case DOUBLE: {
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                if (!(value instanceof String)) break;
                return Double.parseDouble((String)value);
            }
            case BOOLEAN: {
                if (!(value instanceof String)) break;
                return Boolean.parseBoolean((String)value);
            }
            case STRING: {
                return value.toString();
            }
            case MESSAGE: {
                if (!(value instanceof Struct) || field.getMessageType().getFullName().equals(Struct.getDescriptor().getFullName())) break;
                return this.structToMessage((Struct)value, field.getMessageType());
            }
        }
        throw new IllegalArgumentException("Cannot convert value of type " + value.getClass().getName() + " to field type " + String.valueOf(field.getJavaType()));
    }

    private boolean isCompatibleType(Object value, Descriptors.FieldDescriptor field) {
        return switch (field.getJavaType()) {
            case Descriptors.FieldDescriptor.JavaType.INT -> value instanceof Integer;
            case Descriptors.FieldDescriptor.JavaType.LONG -> value instanceof Long;
            case Descriptors.FieldDescriptor.JavaType.FLOAT -> value instanceof Float;
            case Descriptors.FieldDescriptor.JavaType.DOUBLE -> value instanceof Double;
            case Descriptors.FieldDescriptor.JavaType.BOOLEAN -> value instanceof Boolean;
            case Descriptors.FieldDescriptor.JavaType.STRING -> value instanceof String;
            case Descriptors.FieldDescriptor.JavaType.BYTE_STRING -> value instanceof ByteString;
            case Descriptors.FieldDescriptor.JavaType.ENUM -> value instanceof Descriptors.EnumValueDescriptor;
            case Descriptors.FieldDescriptor.JavaType.MESSAGE -> value instanceof Message;
            default -> false;
        };
    }
}

