/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.common.util.descriptor;

import ai.pipestream.common.util.descriptor.DescriptorLoader;
import com.google.protobuf.Descriptors;
import java.util.List;

public class ApicurioDescriptorLoader
implements DescriptorLoader {
    private final String registryUrl;
    private final String groupId;
    private final String artifactId;

    public ApicurioDescriptorLoader(String registryUrl, String groupId, String artifactId) {
        this.registryUrl = registryUrl;
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    @Override
    public List<Descriptors.FileDescriptor> loadDescriptors() throws DescriptorLoader.DescriptorLoadException {
        throw new DescriptorLoader.DescriptorLoadException("Apicurio integration not yet implemented. Please use GoogleDescriptorLoader for now.");
    }

    @Override
    public Descriptors.FileDescriptor loadDescriptor(String fileName) throws DescriptorLoader.DescriptorLoadException {
        throw new DescriptorLoader.DescriptorLoadException("Apicurio integration not yet implemented. Please use GoogleDescriptorLoader for now.");
    }

    @Override
    public boolean isAvailable() {
        return false;
    }

    @Override
    public String getLoaderType() {
        return "Apicurio Schema Registry";
    }

    public String getRegistryUrl() {
        return this.registryUrl;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String registryUrl;
        private String groupId;
        private String artifactId;
        private String apiKey;
        private boolean enableCaching = true;

        public Builder registryUrl(String registryUrl) {
            this.registryUrl = registryUrl;
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Builder authentication(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder enableCaching(boolean enableCaching) {
            this.enableCaching = enableCaching;
            return this;
        }

        public ApicurioDescriptorLoader build() {
            if (this.registryUrl == null || this.registryUrl.isEmpty()) {
                throw new IllegalArgumentException("Registry URL is required");
            }
            if (this.groupId == null || this.groupId.isEmpty()) {
                throw new IllegalArgumentException("Group ID is required");
            }
            return new ApicurioDescriptorLoader(this.registryUrl, this.groupId, this.artifactId);
        }
    }
}

