/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.common.util.descriptor;

import ai.pipestream.common.util.descriptor.DescriptorLoader;
import com.google.protobuf.Any;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.StringValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GoogleDescriptorLoader
implements DescriptorLoader {
    private final String descriptorPath;
    private final ClassLoader classLoader;
    public static final String DEFAULT_DESCRIPTOR_PATH = "META-INF/grpc/services.dsc";

    public GoogleDescriptorLoader() {
        this(DEFAULT_DESCRIPTOR_PATH);
    }

    public GoogleDescriptorLoader(String descriptorPath) {
        this(descriptorPath, Thread.currentThread().getContextClassLoader());
    }

    public GoogleDescriptorLoader(String descriptorPath, ClassLoader classLoader) {
        this.descriptorPath = descriptorPath;
        this.classLoader = classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
    }

    @Override
    public List<Descriptors.FileDescriptor> loadDescriptors() throws DescriptorLoader.DescriptorLoadException {
        List<Descriptors.FileDescriptor> list;
        block10: {
            InputStream inputStream = this.classLoader.getResourceAsStream(this.descriptorPath);
            try {
                if (inputStream == null) {
                    throw new DescriptorLoader.DescriptorLoadException("Descriptor file not found on classpath: " + this.descriptorPath);
                }
                DescriptorProtos.FileDescriptorSet descriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)inputStream);
                list = this.buildFileDescriptors(descriptorSet);
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DescriptorLoader.DescriptorLoadException("Failed to read descriptor file: " + this.descriptorPath, e);
                }
                catch (Descriptors.DescriptorValidationException e) {
                    throw new DescriptorLoader.DescriptorLoadException("Invalid descriptor in file: " + this.descriptorPath, e);
                }
            }
            inputStream.close();
        }
        return list;
    }

    @Override
    public Descriptors.FileDescriptor loadDescriptor(String fileName) throws DescriptorLoader.DescriptorLoadException {
        List<Descriptors.FileDescriptor> allDescriptors = this.loadDescriptors();
        return allDescriptors.stream().filter(fd -> fd.getName().equals(fileName)).findFirst().orElse(null);
    }

    @Override
    public boolean isAvailable() {
        InputStream stream = this.classLoader.getResourceAsStream(this.descriptorPath);
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public String getLoaderType() {
        return "Google Descriptor File";
    }

    public String getDescriptorPath() {
        return this.descriptorPath;
    }

    private List<Descriptors.FileDescriptor> buildFileDescriptors(DescriptorProtos.FileDescriptorSet descriptorSet) throws Descriptors.DescriptorValidationException {
        HashMap<String, Descriptors.FileDescriptor> descriptorMap = new HashMap<String, Descriptors.FileDescriptor>();
        HashMap<String, DescriptorProtos.FileDescriptorProto> protoMap = new HashMap<String, DescriptorProtos.FileDescriptorProto>();
        for (DescriptorProtos.FileDescriptorProto proto : descriptorSet.getFileList()) {
            protoMap.put(proto.getName(), proto);
        }
        for (DescriptorProtos.FileDescriptorProto proto : descriptorSet.getFileList()) {
            if (descriptorMap.containsKey(proto.getName())) continue;
            this.buildFileDescriptor(proto, protoMap, descriptorMap);
        }
        return new ArrayList<Descriptors.FileDescriptor>(descriptorMap.values());
    }

    private Descriptors.FileDescriptor buildFileDescriptor(DescriptorProtos.FileDescriptorProto proto, Map<String, DescriptorProtos.FileDescriptorProto> protoMap, Map<String, Descriptors.FileDescriptor> descriptorMap) throws Descriptors.DescriptorValidationException {
        if (descriptorMap.containsKey(proto.getName())) {
            return descriptorMap.get(proto.getName());
        }
        ArrayList<Descriptors.FileDescriptor> dependencies = new ArrayList<Descriptors.FileDescriptor>();
        for (String dependency : proto.getDependencyList()) {
            Descriptors.FileDescriptor depDescriptor = descriptorMap.get(dependency);
            if (depDescriptor == null) {
                DescriptorProtos.FileDescriptorProto depProto = protoMap.get(dependency);
                if (depProto != null) {
                    depDescriptor = this.buildFileDescriptor(depProto, protoMap, descriptorMap);
                } else {
                    depDescriptor = this.tryGetWellKnownType(dependency);
                    if (depDescriptor == null) {
                        throw new IllegalStateException("Missing dependency: " + dependency + " for " + proto.getName());
                    }
                }
            }
            dependencies.add(depDescriptor);
        }
        Descriptors.FileDescriptor descriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)proto, (Descriptors.FileDescriptor[])dependencies.toArray(new Descriptors.FileDescriptor[0]));
        descriptorMap.put(proto.getName(), descriptor);
        return descriptor;
    }

    private Descriptors.FileDescriptor tryGetWellKnownType(String fileName) {
        try {
            switch (fileName) {
                case "google/protobuf/any.proto": {
                    return Any.getDescriptor().getFile();
                }
                case "google/protobuf/struct.proto": {
                    return Struct.getDescriptor().getFile();
                }
                case "google/protobuf/timestamp.proto": {
                    return Timestamp.getDescriptor().getFile();
                }
                case "google/protobuf/duration.proto": {
                    return Duration.getDescriptor().getFile();
                }
                case "google/protobuf/empty.proto": {
                    return Empty.getDescriptor().getFile();
                }
                case "google/protobuf/field_mask.proto": {
                    return FieldMask.getDescriptor().getFile();
                }
                case "google/protobuf/wrappers.proto": {
                    return StringValue.getDescriptor().getFile();
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static GoogleDescriptorLoader searchPaths(String ... paths) {
        for (String path : paths) {
            GoogleDescriptorLoader loader = new GoogleDescriptorLoader(path);
            if (!loader.isAvailable()) continue;
            return loader;
        }
        return new GoogleDescriptorLoader(paths.length > 0 ? paths[0] : DEFAULT_DESCRIPTOR_PATH);
    }
}

