/*
 * Decompiled with CFR 0.152.
 */
package ai.pipestream.common.validation;

import ai.pipestream.api.validation.ValidationResult;
import java.util.ArrayList;
import java.util.List;

public record DefaultValidationResult(boolean valid, List<String> errors, List<String> warnings) implements ValidationResult
{
    public DefaultValidationResult {
        errors = errors != null ? List.copyOf(errors) : List.of();
        warnings = warnings != null ? List.copyOf(warnings) : List.of();
    }

    public static ValidationResult success() {
        return new DefaultValidationResult(true, List.of(), List.of());
    }

    public static ValidationResult successWithWarnings(List<String> warnings) {
        return new DefaultValidationResult(true, List.of(), warnings);
    }

    public static ValidationResult failure(List<String> errors) {
        return new DefaultValidationResult(false, errors, List.of());
    }

    public static ValidationResult failure(String error) {
        return new DefaultValidationResult(false, List.of(error), List.of());
    }

    public static ValidationResult failure(List<String> errors, List<String> warnings) {
        return new DefaultValidationResult(false, errors, warnings);
    }

    public ValidationResult combine(ValidationResult other) {
        if (other == null) {
            return this;
        }
        ArrayList<String> combinedErrors = new ArrayList<String>(this.errors);
        combinedErrors.addAll(other.errors());
        ArrayList<String> combinedWarnings = new ArrayList<String>(this.warnings);
        combinedWarnings.addAll(other.warnings());
        return new DefaultValidationResult(this.valid && other.valid(), combinedErrors, combinedWarnings);
    }

    public boolean hasIssues() {
        return !this.errors.isEmpty() || !this.warnings.isEmpty();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }
}

