/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.avro.store;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Properties;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.gora.avro.query.AvroQuery;
import org.apache.gora.avro.query.AvroResult;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.query.impl.FileSplitPartitionQuery;
import org.apache.gora.store.DataStoreFactory;
import org.apache.gora.store.impl.FileBackedDataStoreBase;
import org.apache.gora.util.GoraException;
import org.apache.gora.util.OperationNotSupportedException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroStore<K, T extends PersistentBase>
extends FileBackedDataStoreBase<K, T>
implements Configurable {
    public static final String CODEC_TYPE_KEY = "codec.type";
    public static final Logger LOG = LoggerFactory.getLogger(AvroStore.class);
    private DatumReader<T> datumReader;
    private DatumWriter<T> datumWriter;
    private Encoder encoder;
    private Decoder decoder;
    private CodecType codecType = CodecType.JSON;

    @Override
    public boolean exists(K key) throws GoraException {
        return this.get((Object)key) != null;
    }

    @Override
    public void initialize(Class<K> keyClass, Class<T> persistentClass, Properties properties) throws GoraException {
        super.initialize(keyClass, persistentClass, properties);
        if (properties != null && this.codecType == null) {
            String codecType = DataStoreFactory.findProperty(properties, this, CODEC_TYPE_KEY, "BINARY");
            this.codecType = CodecType.valueOf(codecType);
        }
    }

    public void setCodecType(CodecType codecType) {
        this.codecType = codecType;
    }

    public void setEncoder(Encoder encoder) {
        this.encoder = encoder;
    }

    public void setDecoder(Decoder decoder) {
        this.decoder = decoder;
    }

    public void setDatumReader(DatumReader<T> datumReader) {
        this.datumReader = datumReader;
    }

    public void setDatumWriter(DatumWriter<T> datumWriter) {
        this.datumWriter = datumWriter;
    }

    @Override
    public void close() {
        try {
            super.close();
            if (this.encoder != null) {
                this.encoder.flush();
            }
            this.encoder = null;
            this.decoder = null;
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public boolean delete(K key) throws GoraException {
        throw new OperationNotSupportedException("delete is not supported for AvroStore");
    }

    @Override
    public long deleteByQuery(Query<K, T> query) throws GoraException {
        throw new OperationNotSupportedException("delete is not supported for AvroStore");
    }

    @Override
    protected Result<K, T> executeQuery(Query<K, T> query) throws IOException {
        return new AvroResult(this, (AvroQuery)query, this.getDatumReader(), this.getDecoder());
    }

    @Override
    protected Result<K, T> executePartial(FileSplitPartitionQuery<K, T> query) throws IOException {
        throw new OperationNotSupportedException("Not yet implemented");
    }

    @Override
    public void flush() throws GoraException {
        try {
            super.flush();
            if (this.encoder != null) {
                this.encoder.flush();
            }
        }
        catch (Exception e) {
            throw new GoraException(e);
        }
    }

    @Override
    public T get(K key, String[] fields) throws GoraException {
        throw new OperationNotSupportedException();
    }

    @Override
    public AvroQuery<K, T> newQuery() {
        return new AvroQuery(this);
    }

    @Override
    public void put(K key, T obj) throws GoraException {
        try {
            this.getDatumWriter().write(obj, this.getEncoder());
        }
        catch (Exception e) {
            throw new GoraException(e);
        }
    }

    public Encoder getEncoder() throws IOException {
        if (this.encoder == null) {
            this.encoder = this.createEncoder();
        }
        return this.encoder;
    }

    public Decoder getDecoder() throws IOException {
        if (this.decoder == null) {
            this.decoder = this.createDecoder();
        }
        return this.decoder;
    }

    public DatumReader<T> getDatumReader() {
        if (this.datumReader == null) {
            this.datumReader = this.createDatumReader();
        }
        return this.datumReader;
    }

    public DatumWriter<T> getDatumWriter() {
        if (this.datumWriter == null) {
            this.datumWriter = this.createDatumWriter();
        }
        return this.datumWriter;
    }

    protected Encoder createEncoder() throws IOException {
        switch (this.codecType) {
            case BINARY: {
                return EncoderFactory.get().binaryEncoder(this.getOrCreateOutputStream(), null);
            }
            case JSON: {
                return EncoderFactory.get().jsonEncoder(this.schema, this.getOrCreateOutputStream());
            }
        }
        return null;
    }

    protected Decoder createDecoder() throws IOException {
        switch (this.codecType) {
            case BINARY: {
                return DecoderFactory.get().binaryDecoder(this.getOrCreateInputStream(), null);
            }
            case JSON: {
                return DecoderFactory.get().jsonDecoder(this.schema, this.getOrCreateInputStream());
            }
        }
        return null;
    }

    protected DatumWriter<T> createDatumWriter() {
        return new SpecificDatumWriter(this.schema);
    }

    protected DatumReader<T> createDatumReader() {
        return new SpecificDatumReader(this.schema);
    }

    @Override
    public Configuration getConf() {
        if (this.conf == null) {
            this.conf = new Configuration();
        }
        return this.conf;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
    }

    @Override
    public String getSchemaName() {
        return "default";
    }

    public static enum CodecType {
        BINARY,
        JSON;

    }
}

