/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.avro.store;

import java.io.IOException;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.mapred.FsInput;
import org.apache.gora.avro.query.DataFileAvroResult;
import org.apache.gora.avro.store.AvroStore;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.query.impl.FileSplitPartitionQuery;
import org.apache.gora.util.GoraException;
import org.apache.gora.util.OperationNotSupportedException;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFileAvroStore<K, T extends PersistentBase>
extends AvroStore<K, T> {
    public static final Logger LOG = LoggerFactory.getLogger(AvroStore.class);
    private DataFileWriter<T> writer;

    @Override
    public T get(K key, String[] fields) throws GoraException {
        throw new OperationNotSupportedException("Avro DataFile's does not support indexed retrieval");
    }

    @Override
    public void put(K key, T obj) throws GoraException {
        try {
            this.getWriter().append(obj);
        }
        catch (Exception e) {
            throw new GoraException(e);
        }
    }

    private DataFileWriter<T> getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new DataFileWriter(this.getDatumWriter());
            this.writer.create(this.schema, this.getOrCreateOutputStream());
        }
        return this.writer;
    }

    @Override
    protected Result<K, T> executeQuery(Query<K, T> query) throws IOException {
        return new DataFileAvroResult<K, T>(this, query, this.createReader(this.createFsInput()));
    }

    @Override
    protected Result<K, T> executePartial(FileSplitPartitionQuery<K, T> query) throws IOException {
        FsInput fsInput = this.createFsInput();
        DataFileReader<T> reader = this.createReader(fsInput);
        return new DataFileAvroResult<K, T>(this, query, reader, (SeekableInput)fsInput, query.getStart(), query.getLength());
    }

    private DataFileReader<T> createReader(FsInput fsInput) throws IOException {
        return new DataFileReader((SeekableInput)fsInput, this.getDatumReader());
    }

    private FsInput createFsInput() throws IOException {
        Path path = new Path(this.getInputPath());
        return new FsInput(path, this.getConf());
    }

    @Override
    public void flush() throws GoraException {
        try {
            super.flush();
            if (this.writer != null) {
                this.writer.flush();
            }
        }
        catch (GoraException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GoraException(e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            this.writer = null;
            super.close();
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

