/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.util.Utf8;
import org.apache.gora.filter.Filter;
import org.apache.gora.filter.FilterOp;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;

public class MapFieldValueFilter<K, T extends PersistentBase>
implements Filter<K, T> {
    protected String fieldName;
    protected Utf8 mapKey;
    protected FilterOp filterOp;
    protected List<Object> operands = new ArrayList<Object>();
    protected boolean filterIfMissing = false;
    private Configuration conf = new Configuration();

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.fieldName);
        Text.writeString((DataOutput)out, (String)this.mapKey.toString());
        WritableUtils.writeEnum((DataOutput)out, (Enum)this.filterOp);
        WritableUtils.writeVInt((DataOutput)out, (int)this.operands.size());
        for (Object operand : this.operands) {
            if (operand instanceof String) {
                throw new IllegalStateException("Use Utf8 instead of String for operands");
            }
            if (operand instanceof Utf8) {
                operand = operand.toString();
            }
            if (operand instanceof Boolean) {
                ObjectWritable.writeObject((DataOutput)out, (Object)operand, Boolean.TYPE, (Configuration)this.conf);
                continue;
            }
            if (operand instanceof Character) {
                ObjectWritable.writeObject((DataOutput)out, (Object)operand, Character.TYPE, (Configuration)this.conf);
                continue;
            }
            if (operand instanceof Byte) {
                ObjectWritable.writeObject((DataOutput)out, (Object)operand, Byte.TYPE, (Configuration)this.conf);
                continue;
            }
            if (operand instanceof Short) {
                ObjectWritable.writeObject((DataOutput)out, (Object)operand, Short.TYPE, (Configuration)this.conf);
                continue;
            }
            if (operand instanceof Integer) {
                ObjectWritable.writeObject((DataOutput)out, (Object)operand, Integer.TYPE, (Configuration)this.conf);
                continue;
            }
            if (operand instanceof Long) {
                ObjectWritable.writeObject((DataOutput)out, (Object)operand, Long.TYPE, (Configuration)this.conf);
                continue;
            }
            if (operand instanceof Float) {
                ObjectWritable.writeObject((DataOutput)out, (Object)operand, Float.TYPE, (Configuration)this.conf);
                continue;
            }
            if (operand instanceof Double) {
                ObjectWritable.writeObject((DataOutput)out, (Object)operand, Double.TYPE, (Configuration)this.conf);
                continue;
            }
            if (operand instanceof Void) {
                ObjectWritable.writeObject((DataOutput)out, (Object)operand, Void.TYPE, (Configuration)this.conf);
                continue;
            }
            ObjectWritable.writeObject((DataOutput)out, (Object)operand, operand.getClass(), (Configuration)this.conf);
        }
        out.writeBoolean(this.filterIfMissing);
    }

    public void readFields(DataInput in) throws IOException {
        this.fieldName = Text.readString((DataInput)in);
        this.mapKey = new Utf8(Text.readString((DataInput)in));
        this.filterOp = (FilterOp)WritableUtils.readEnum((DataInput)in, FilterOp.class);
        this.operands.clear();
        int operandsSize = WritableUtils.readVInt((DataInput)in);
        for (int i = 0; i < operandsSize; ++i) {
            Object operand = ObjectWritable.readObject((DataInput)in, (Configuration)this.conf);
            if (operand instanceof String) {
                operand = new Utf8((String)operand);
            }
            this.operands.add(operand);
        }
        this.filterIfMissing = in.readBoolean();
    }

    @Override
    public boolean filter(K key, T persistent) {
        int fieldIndex = persistent.getSchema().getField(this.fieldName).pos();
        Map fieldValue = (Map)persistent.get(fieldIndex);
        if (fieldValue == null) {
            return this.filterIfMissing;
        }
        Object value = fieldValue.get(this.mapKey);
        Object operand = this.operands.get(0);
        if (value == null) {
            return this.filterIfMissing;
        }
        if (this.filterOp.equals((Object)FilterOp.EQUALS)) {
            boolean equals = value.equals(operand);
            return !equals;
        }
        if (this.filterOp.equals((Object)FilterOp.NOT_EQUALS)) {
            boolean equals = value.equals(operand);
            return equals;
        }
        throw new IllegalStateException((Object)((Object)this.filterOp) + " not yet implemented!");
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Utf8 getMapKey() {
        return this.mapKey;
    }

    public void setMapKey(Utf8 mapKey) {
        this.mapKey = mapKey;
    }

    public FilterOp getFilterOp() {
        return this.filterOp;
    }

    public void setFilterOp(FilterOp filterOp) {
        this.filterOp = filterOp;
    }

    public List<Object> getOperands() {
        return this.operands;
    }

    public void setOperands(List<Object> operands) {
        this.operands = operands;
    }

    public void setFilterIfMissing(boolean filterIfMissing) {
        this.filterIfMissing = filterIfMissing;
    }

    public boolean isFilterIfMissing() {
        return this.filterIfMissing;
    }

    public String toString() {
        return "SingleFieldValueFilter [fieldName=" + this.fieldName + ",mapKey=" + this.mapKey + ", filterOp=" + (Object)((Object)this.filterOp) + ", operands=" + this.operands + ", filterIfMissing=" + this.filterIfMissing + "]";
    }
}

