/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.flink;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.api.common.typeutils.base.ByteValueSerializer;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.gora.mapreduce.PersistentDeserializer;
import org.apache.gora.mapreduce.PersistentSerializer;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.util.AvroUtils;

public class PersistentTypeSerializer<T extends PersistentBase>
extends TypeSerializerSingleton<T> {
    private static final long serialVersionUID = 1L;
    private Class<T> persistentClass;

    public PersistentTypeSerializer(Class<T> persistentClass) {
        this.persistentClass = persistentClass;
    }

    public boolean isImmutableType() {
        return false;
    }

    public T createInstance() {
        return null;
    }

    public T copy(T from) {
        return AvroUtils.deepClonePersistent(from);
    }

    public T copy(T from, T reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(T record, DataOutputView target) throws IOException {
        PersistentSerializer serializer = new PersistentSerializer();
        DataOutputViewStream outViewWrapper = new DataOutputViewStream(target);
        try {
            serializer.open((OutputStream)outViewWrapper);
            serializer.serialize((PersistentBase)record);
        }
        finally {
            serializer.close();
            outViewWrapper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T deserialize(DataInputView source) throws IOException {
        PersistentDeserializer deserializer = new PersistentDeserializer(this.persistentClass, false);
        DataInputViewStream inViewWrapper = new DataInputViewStream(source);
        try {
            deserializer.open((InputStream)inViewWrapper);
            PersistentBase persistentBase = deserializer.deserialize(null);
            return (T)persistentBase;
        }
        finally {
            deserializer.close();
            inViewWrapper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T deserialize(T reuse, DataInputView source) throws IOException {
        PersistentDeserializer deserializer = new PersistentDeserializer(this.persistentClass, true);
        DataInputViewStream inViewWrapper = new DataInputViewStream(source);
        try {
            deserializer.open((InputStream)inViewWrapper);
            PersistentBase persistentBase = deserializer.deserialize((PersistentBase)reuse);
            return (T)persistentBase;
        }
        finally {
            deserializer.close();
            inViewWrapper.close();
        }
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        Object record = this.deserialize(source);
        this.serialize((T)record, target);
    }

    public boolean canEqual(Object obj) {
        return obj instanceof PersistentTypeSerializer;
    }

    protected boolean isCompatibleSerializationFormatIdentifier(String identifier) {
        return super.isCompatibleSerializationFormatIdentifier(identifier) || identifier.equals(ByteValueSerializer.class.getCanonicalName());
    }
}

