/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.gora.query.PartitionQuery;
import org.apache.gora.util.IOUtils;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class GoraInputSplit
extends InputSplit
implements Writable,
Configurable {
    protected PartitionQuery<?, ?> query;
    protected Configuration conf;

    public GoraInputSplit() {
    }

    public GoraInputSplit(Configuration conf, PartitionQuery<?, ?> query) {
        this.setConf(conf);
        this.query = query;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public long getLength() throws IOException, InterruptedException {
        return 0L;
    }

    public String[] getLocations() {
        return this.query.getLocations();
    }

    public PartitionQuery<?, ?> getQuery() {
        return this.query;
    }

    public void readFields(DataInput in) throws IOException {
        try {
            this.conf = new Configuration();
            this.conf.readFields(in);
            this.query = IOUtils.deserialize(this.conf, in, null);
        }
        catch (ClassNotFoundException ex) {
            throw new IOException(ex);
        }
    }

    public void write(DataOutput out) throws IOException {
        this.conf.write(out);
        IOUtils.serialize(this.getConf(), out, this.query);
    }

    public boolean equals(Object obj) {
        if (obj instanceof GoraInputSplit) {
            return this.query.equals(((GoraInputSplit)((Object)obj)).query);
        }
        return false;
    }
}

