/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.mapreduce;

import java.io.IOException;
import java.util.List;
import org.apache.gora.mapreduce.PersistentSerialization;
import org.apache.gora.mapreduce.StringSerialization;
import org.apache.gora.util.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.task.JobContextImpl;

public class GoraMapReduceUtils {
    public static void setIOSerializations(Configuration conf, boolean reuseObjects) {
        String serializationClass = PersistentSerialization.class.getCanonicalName();
        String[] serializations = StringUtils.joinStringArrays(conf.getStrings("io.serializations"), "org.apache.hadoop.io.serializer.WritableSerialization", StringSerialization.class.getCanonicalName(), serializationClass);
        conf.setStrings("io.serializations", serializations);
    }

    public static List<InputSplit> getSplits(Configuration conf, String inputPath) throws IOException {
        JobContext context = GoraMapReduceUtils.createJobContext(conf, inputPath);
        HelperInputFormat inputFormat = new HelperInputFormat();
        return inputFormat.getSplits(context);
    }

    public static JobContext createJobContext(Configuration conf, String inputPath) throws IOException {
        if (inputPath != null) {
            Job job = Job.getInstance((Configuration)conf);
            FileInputFormat.addInputPath((Job)job, (Path)new Path(inputPath));
            return new JobContextImpl(job.getConfiguration(), null);
        }
        return new JobContextImpl(conf, null);
    }

    public static class HelperInputFormat<K, V>
    extends FileInputFormat<K, V> {
        public RecordReader<K, V> createRecordReader(InputSplit arg0, TaskAttemptContext arg1) throws IOException, InterruptedException {
            return null;
        }
    }
}

