/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.mapreduce;

import java.io.IOException;
import org.apache.gora.mapreduce.GoraInputFormat;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.query.Query;
import org.apache.gora.store.DataStore;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;

public class GoraMapper<K1, V1 extends Persistent, K2, V2>
extends Mapper<K1, V1, K2, V2> {
    public static <K1, V1 extends Persistent, K2, V2> void initMapperJob(Job job, Class<? extends DataStore<K1, V1>> dataStoreClass, Class<K1> inKeyClass, Class<V1> inValueClass, Class<K2> outKeyClass, Class<V2> outValueClass, Class<? extends GoraMapper> mapperClass, Class<? extends Partitioner> partitionerClass, boolean reuseObjects) throws IOException {
        GoraInputFormat.setInput(job, dataStoreClass, inKeyClass, inValueClass, reuseObjects);
        job.setMapperClass(mapperClass);
        job.setMapOutputKeyClass(outKeyClass);
        job.setMapOutputValueClass(outValueClass);
        if (partitionerClass != null) {
            job.setPartitionerClass(partitionerClass);
        }
    }

    public static <K1, V1 extends Persistent, K2, V2> void initMapperJob(Job job, Class<? extends DataStore<K1, V1>> dataStoreClass, Class<K1> inKeyClass, Class<V1> inValueClass, Class<K2> outKeyClass, Class<V2> outValueClass, Class<? extends GoraMapper> mapperClass, boolean reuseObjects) throws IOException {
        GoraMapper.initMapperJob(job, dataStoreClass, inKeyClass, inValueClass, outKeyClass, outValueClass, mapperClass, null, reuseObjects);
    }

    public static <K1, V1 extends Persistent, K2, V2> void initMapperJob(Job job, Query<K1, V1> query, Class<K2> outKeyClass, Class<V2> outValueClass, Class<? extends GoraMapper> mapperClass, Class<? extends Partitioner> partitionerClass, boolean reuseObjects) throws IOException {
        GoraInputFormat.setInput(job, query, reuseObjects);
        job.setMapperClass(mapperClass);
        job.setMapOutputKeyClass(outKeyClass);
        job.setMapOutputValueClass(outValueClass);
        if (partitionerClass != null) {
            job.setPartitionerClass(partitionerClass);
        }
    }

    public static <K1, V1 extends Persistent, K2, V2> void initMapperJob(Job job, DataStore<K1, V1> dataStore, Class<K2> outKeyClass, Class<V2> outValueClass, Class<? extends GoraMapper> mapperClass, boolean reuseObjects) throws IOException {
        GoraMapper.initMapperJob(job, dataStore.newQuery(), outKeyClass, outValueClass, mapperClass, reuseObjects);
    }

    public static <K1, V1 extends Persistent, K2, V2> void initMapperJob(Job job, Query<K1, V1> query, Class<K2> outKeyClass, Class<V2> outValueClass, Class<? extends GoraMapper> mapperClass, boolean reuseObjects) throws IOException {
        GoraMapper.initMapperJob(job, query, outKeyClass, outValueClass, mapperClass, null, reuseObjects);
    }
}

