/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.mapreduce;

import java.io.IOException;
import org.apache.gora.mapreduce.GoraMapReduceUtils;
import org.apache.gora.mapreduce.GoraRecordWriter;
import org.apache.gora.mapreduce.NullOutputCommitter;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.store.DataStore;
import org.apache.gora.store.DataStoreFactory;
import org.apache.gora.store.FileBackedDataStore;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class GoraOutputFormat<K, T extends Persistent>
extends OutputFormat<K, T> {
    public static final String DATA_STORE_CLASS = "gora.outputformat.datastore.class";
    public static final String OUTPUT_KEY_CLASS = "gora.outputformat.key.class";
    public static final String OUTPUT_VALUE_CLASS = "gora.outputformat.value.class";

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new NullOutputCommitter();
    }

    private void setOutputPath(DataStore<K, T> store, TaskAttemptContext context) {
        if (store instanceof FileBackedDataStore) {
            FileBackedDataStore fileStore = (FileBackedDataStore)store;
            String uniqueName = FileOutputFormat.getUniqueFile((TaskAttemptContext)context, (String)"part", (String)"");
            if (fileStore.getOutputPath() == null) {
                fileStore.setOutputPath(FileOutputFormat.getOutputPath((JobContext)context).toString());
            }
            String path = fileStore.getOutputPath();
            fileStore.setOutputPath(path + "/" + uniqueName);
        }
    }

    public RecordWriter<K, T> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        Class dataStoreClass = conf.getClass(DATA_STORE_CLASS, null);
        Class keyClass = conf.getClass(OUTPUT_KEY_CLASS, null);
        Class rowClass = conf.getClass(OUTPUT_VALUE_CLASS, null);
        Object store = DataStoreFactory.createDataStore(dataStoreClass, keyClass, rowClass, context.getConfiguration());
        this.setOutputPath((DataStore<K, T>)store, context);
        return new GoraRecordWriter(store, context);
    }

    public static <K, V extends Persistent> void setOutput(Job job, DataStore<K, V> dataStore, boolean reuseObjects) {
        GoraOutputFormat.setOutput(job, dataStore.getClass(), dataStore.getKeyClass(), dataStore.getPersistentClass(), reuseObjects);
    }

    public static <K, V extends Persistent> void setOutput(Job job, Class<? extends DataStore> dataStoreClass, Class<K> keyClass, Class<V> persistentClass, boolean reuseObjects) {
        Configuration conf = job.getConfiguration();
        GoraMapReduceUtils.setIOSerializations(conf, reuseObjects);
        job.setOutputFormatClass(GoraOutputFormat.class);
        job.setOutputKeyClass(keyClass);
        job.setOutputValueClass(persistentClass);
        conf.setClass(DATA_STORE_CLASS, dataStoreClass, DataStore.class);
        conf.setClass(OUTPUT_KEY_CLASS, keyClass, Object.class);
        conf.setClass(OUTPUT_VALUE_CLASS, persistentClass, Persistent.class);
    }
}

