/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.mapreduce;

import java.io.IOException;
import org.apache.gora.mapreduce.GoraRecordCounter;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoraRecordReader<K, T extends PersistentBase>
extends RecordReader<K, T> {
    public static final Logger LOG = LoggerFactory.getLogger(GoraRecordReader.class);
    public static final String BUFFER_LIMIT_READ_NAME = "gora.buffer.read.limit";
    public static final int BUFFER_LIMIT_READ_VALUE = 10000;
    protected Query<K, T> query;
    protected Result<K, T> result;
    private GoraRecordCounter counter = new GoraRecordCounter();

    public GoraRecordReader(Query<K, T> query, TaskAttemptContext context) {
        this.query = query;
        Configuration configuration = context.getConfiguration();
        int recordsMax = configuration.getInt(BUFFER_LIMIT_READ_NAME, 10000);
        if (recordsMax <= 1) {
            LOG.info("Limit " + recordsMax + " changed to " + 10000);
            recordsMax = 10000;
        }
        this.counter.setRecordsMax(recordsMax);
        LOG.info("gora.buffer.read.limit = " + recordsMax);
        this.query.setLimit(recordsMax);
    }

    public void executeQuery() throws Exception {
        this.result = this.query.execute();
    }

    public K getCurrentKey() throws IOException, InterruptedException {
        return this.result.getKey();
    }

    public T getCurrentValue() throws IOException, InterruptedException {
        return (T)((PersistentBase)this.result.get());
    }

    public float getProgress() throws IOException, InterruptedException {
        try {
            return this.result.getProgress();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        try {
            if (this.counter.isModulo()) {
                boolean firstBatch;
                boolean bl = firstBatch = this.result == null;
                if (!firstBatch) {
                    this.query.setStartKey(this.result.getKey());
                    if (this.query.getLimit() == (long)this.counter.getRecordsMax()) {
                        this.query.setLimit(this.counter.getRecordsMax() + 1);
                    }
                }
                if (this.result != null) {
                    this.result.close();
                }
                this.executeQuery();
                if (!firstBatch) {
                    this.result.next();
                }
            }
            this.counter.increment();
            return this.result.next();
        }
        catch (Exception e) {
            LOG.error("Error reading Gora records: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
        if (this.result != null) {
            this.result.close();
        }
    }
}

