/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.mapreduce;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.util.AvroUtils;
import org.apache.hadoop.io.serializer.Deserializer;

public class PersistentDeserializer
implements Deserializer<PersistentBase> {
    private BinaryDecoder decoder;
    private Class<? extends PersistentBase> persistentClass;
    private boolean reuseObjects;
    private SpecificDatumReader<PersistentBase> datumReader;

    public PersistentDeserializer(Class<? extends PersistentBase> c, boolean reuseObjects) {
        this.persistentClass = c;
        this.reuseObjects = reuseObjects;
        try {
            Schema schema = AvroUtils.getSchema(this.persistentClass);
            this.datumReader = new SpecificDatumReader(schema);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void open(InputStream in) throws IOException {
        this.decoder = DecoderFactory.get().directBinaryDecoder(in, this.decoder);
    }

    public void close() throws IOException {
    }

    public PersistentBase deserialize(PersistentBase persistent) throws IOException {
        persistent = (PersistentBase)this.datumReader.read((Object)(this.reuseObjects ? persistent : null), (Decoder)this.decoder);
        byte[] __g__dirty = new byte[persistent.getFieldsCount()];
        this.decoder.readFixed(__g__dirty);
        persistent.setDirtyBytes(ByteBuffer.wrap(__g__dirty));
        return persistent;
    }
}

