/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.mapreduce;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

public class StringSerialization
implements Serialization<String> {
    public boolean accept(Class<?> c) {
        return c.equals(String.class);
    }

    public Deserializer<String> getDeserializer(Class<String> c) {
        return new Deserializer<String>(){
            private DataInputStream in;

            public void open(InputStream in) throws IOException {
                this.in = new DataInputStream(in);
            }

            public void close() throws IOException {
                this.in.close();
            }

            public String deserialize(String t) throws IOException {
                return Text.readString((DataInput)this.in);
            }
        };
    }

    public Serializer<String> getSerializer(Class<String> c) {
        return new Serializer<String>(){
            private DataOutputStream out;

            public void close() throws IOException {
                this.out.close();
            }

            public void open(OutputStream out) throws IOException {
                this.out = new DataOutputStream(out);
            }

            public void serialize(String str) throws IOException {
                Text.writeString((DataOutput)this.out, (String)str);
            }
        };
    }
}

