/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.memory.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.avro.Schema;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.PartitionQuery;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.query.impl.PartitionQueryImpl;
import org.apache.gora.query.impl.QueryBase;
import org.apache.gora.query.impl.ResultBase;
import org.apache.gora.store.DataStore;
import org.apache.gora.store.impl.DataStoreBase;
import org.apache.gora.util.AvroUtils;
import org.apache.gora.util.GoraException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemStore<K, T extends PersistentBase>
extends DataStoreBase<K, T> {
    private static final Logger LOG = LoggerFactory.getLogger(MemStore.class);
    public static ConcurrentSkipListMap map = new ConcurrentSkipListMap();

    @Override
    public String getSchemaName() {
        return "MemStore";
    }

    @Override
    public boolean delete(K key) {
        return map.remove(key) != null;
    }

    @Override
    public long deleteByQuery(Query<K, T> query) {
        try {
            long deletedRows = 0L;
            Result<K, T> result = query.execute();
            Object[] fields = this.getFieldsToQuery(query.getFields());
            boolean isAllFields = Arrays.equals(fields, this.getFields());
            while (result.next()) {
                if (isAllFields) {
                    if (!this.delete(result.getKey())) continue;
                    ++deletedRows;
                    continue;
                }
                ArrayList<String> excludedFields = new ArrayList<String>();
                for (String field : this.getFields()) {
                    if (Arrays.asList(fields).contains(field)) continue;
                    excludedFields.add(field);
                }
                PersistentBase newClonedObj = MemStore.getPersistent((PersistentBase)result.get(), excludedFields.toArray(new String[excludedFields.size()]));
                if (!this.delete(result.getKey())) continue;
                this.put(result.getKey(), (T)newClonedObj);
                ++deletedRows;
            }
            return deletedRows;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @Override
    public Result<K, T> execute(Query<K, T> query) throws GoraException {
        K startKey = query.getStartKey();
        K endKey = query.getEndKey();
        if (startKey == null && !map.isEmpty()) {
            startKey = map.firstKey();
        }
        if (endKey == null && !map.isEmpty()) {
            endKey = map.lastKey();
        }
        query.setFields(this.getFieldsToQuery(query.getFields()));
        NavigableMap submap = null;
        if (startKey != null && endKey != null) {
            try {
                submap = map.subMap((Object)startKey, true, (Object)endKey, true);
            }
            catch (Exception e) {
                throw new GoraException(e);
            }
        } else {
            submap = Collections.emptyNavigableMap();
        }
        return new MemResult<K, T>(this, query, submap);
    }

    @Override
    public T get(K key, String[] fields) {
        PersistentBase obj = (PersistentBase)map.get(key);
        if (obj == null) {
            return null;
        }
        return (T)MemStore.getPersistent(obj, this.getFieldsToQuery(fields));
    }

    @Override
    public boolean exists(K key) {
        return map.containsKey(key);
    }

    private static <T extends PersistentBase> T getPersistent(T obj, String[] fields) {
        List otherFields = obj.getSchema().getFields();
        Object[] otherFieldStrings = new String[otherFields.size()];
        for (int i = 0; i < otherFields.size(); ++i) {
            otherFieldStrings[i] = ((Schema.Field)otherFields.get(i)).name();
        }
        if (Arrays.equals(fields, otherFieldStrings)) {
            return obj;
        }
        T newObj = AvroUtils.deepClonePersistent(obj);
        newObj.clear();
        for (String field : fields) {
            Schema.Field otherField = obj.getSchema().getField(field);
            int index = otherField.pos();
            newObj.put(index, obj.get(index));
        }
        return newObj;
    }

    @Override
    public Query<K, T> newQuery() {
        return new MemQuery(this);
    }

    @Override
    public void put(K key, T obj) {
        map.put(key, obj);
    }

    @Override
    public List<PartitionQuery<K, T>> getPartitions(Query<K, T> query) {
        ArrayList<PartitionQuery<K, T>> list = new ArrayList<PartitionQuery<K, T>>();
        PartitionQueryImpl<K, T> pqi = new PartitionQueryImpl<K, T>(query, new String[0]);
        pqi.setConf(this.getConf());
        list.add(pqi);
        return list;
    }

    @Override
    public void close() {
    }

    @Override
    public void createSchema() {
    }

    @Override
    public void deleteSchema() {
        if (!map.isEmpty()) {
            map.clear();
        }
    }

    @Override
    public boolean schemaExists() {
        return true;
    }

    @Override
    public void flush() {
    }

    public static class MemResult<K, T extends PersistentBase>
    extends ResultBase<K, T> {
        private NavigableMap<K, T> map;
        private Iterator<K> iterator;

        public MemResult(DataStore<K, T> dataStore, Query<K, T> query, NavigableMap<K, T> map) {
            super(dataStore, query);
            this.map = map;
            this.iterator = map.navigableKeySet().iterator();
        }

        @Override
        public void close() {
        }

        @Override
        public float getProgress() throws IOException {
            return 0.0f;
        }

        @Override
        protected void clear() {
        }

        @Override
        public boolean nextInner() throws IOException {
            if (!this.iterator.hasNext()) {
                return false;
            }
            this.key = this.iterator.next();
            this.persistent = (Persistent)this.map.get(this.key);
            return true;
        }

        @Override
        public int size() {
            int totalSize = this.map.navigableKeySet().size();
            int intLimit = (int)this.limit;
            return intLimit > 0 && totalSize > intLimit ? intLimit : totalSize;
        }
    }

    public static class MemQuery<K, T extends PersistentBase>
    extends QueryBase<K, T> {
        public MemQuery() {
            super(null);
        }

        public MemQuery(DataStore<K, T> dataStore) {
            super(dataStore);
        }
    }
}

