/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.mongodb.filters;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.gora.filter.Filter;
import org.apache.gora.filter.FilterList;
import org.apache.gora.filter.FilterOp;
import org.apache.gora.filter.MapFieldValueFilter;
import org.apache.gora.filter.SingleFieldValueFilter;
import org.apache.gora.mongodb.filters.BaseFactory;
import org.apache.gora.mongodb.store.MongoMapping;
import org.apache.gora.mongodb.store.MongoStore;
import org.apache.gora.persistency.impl.PersistentBase;
import shaded.com.mongodb.BasicDBObject;
import shaded.com.mongodb.DBObject;
import shaded.com.mongodb.QueryBuilder;

public class DefaultFactory<K, T extends PersistentBase>
extends BaseFactory<K, T> {
    private static final Log LOG = LogFactory.getLog(DefaultFactory.class);

    @Override
    public List<String> getSupportedFilters() {
        ArrayList<String> filters = new ArrayList<String>();
        filters.add(SingleFieldValueFilter.class.getCanonicalName());
        filters.add(MapFieldValueFilter.class.getCanonicalName());
        filters.add(FilterList.class.getCanonicalName());
        return filters;
    }

    @Override
    public DBObject createFilter(Filter<K, T> filter, MongoStore<K, T> store) {
        if (filter instanceof FilterList) {
            FilterList filterList = (FilterList)filter;
            return this.transformListFilter(filterList, store);
        }
        if (filter instanceof SingleFieldValueFilter) {
            SingleFieldValueFilter fieldFilter = (SingleFieldValueFilter)filter;
            return this.transformFieldFilter(fieldFilter, store);
        }
        if (filter instanceof MapFieldValueFilter) {
            MapFieldValueFilter mapFilter = (MapFieldValueFilter)filter;
            return this.transformMapFilter(mapFilter, store);
        }
        LOG.warn((Object)("MongoDB remote filter not yet implemented for " + filter.getClass().getCanonicalName()));
        return null;
    }

    protected DBObject transformListFilter(FilterList<K, T> filterList, MongoStore<K, T> store) {
        BasicDBObject query = new BasicDBObject();
        for (Filter<K, T> filter : filterList.getFilters()) {
            boolean succeeded = this.getFilterUtil().setFilter(query, filter, store);
            if (succeeded) continue;
            return null;
        }
        return query;
    }

    protected DBObject transformFieldFilter(SingleFieldValueFilter<K, T> fieldFilter, MongoStore<K, T> store) {
        MongoMapping mapping = store.getMapping();
        String dbFieldName = mapping.getDocumentField(fieldFilter.getFieldName());
        FilterOp filterOp = fieldFilter.getFilterOp();
        List<Object> operands = fieldFilter.getOperands();
        QueryBuilder builder = QueryBuilder.start(dbFieldName);
        builder = this.appendToBuilder(builder, filterOp, operands);
        if (!fieldFilter.isFilterIfMissing()) {
            DBObject notExist = QueryBuilder.start(dbFieldName).exists(false).get();
            builder = QueryBuilder.start().or(notExist, builder.get());
        }
        return builder.get();
    }

    protected DBObject transformMapFilter(MapFieldValueFilter<K, T> mapFilter, MongoStore<K, T> store) {
        MongoMapping mapping = store.getMapping();
        String dbFieldName = mapping.getDocumentField(mapFilter.getFieldName()) + "." + store.encodeFieldKey(mapFilter.getMapKey().toString());
        FilterOp filterOp = mapFilter.getFilterOp();
        List<Object> operands = mapFilter.getOperands();
        QueryBuilder builder = QueryBuilder.start(dbFieldName);
        builder = this.appendToBuilder(builder, filterOp, operands);
        if (!mapFilter.isFilterIfMissing()) {
            DBObject notExist = QueryBuilder.start(dbFieldName).exists(false).get();
            builder = QueryBuilder.start().or(notExist, builder.get());
        }
        return builder.get();
    }

    protected QueryBuilder appendToBuilder(QueryBuilder builder, FilterOp filterOp, List<Object> rawOperands) {
        List<String> operands = this.convertOperandsToString(rawOperands);
        switch (filterOp) {
            case EQUALS: {
                if (operands.size() == 1) {
                    builder.is(operands.iterator().next());
                    break;
                }
                builder.in(operands);
                break;
            }
            case NOT_EQUALS: {
                if (operands.size() == 1) {
                    builder.notEquals(operands.iterator().next());
                    break;
                }
                builder.notIn(operands);
                break;
            }
            case LESS: {
                builder.lessThan(operands);
                break;
            }
            case LESS_OR_EQUAL: {
                builder.lessThanEquals(operands);
                break;
            }
            case GREATER: {
                builder.greaterThan(operands);
                break;
            }
            case GREATER_OR_EQUAL: {
                builder.greaterThanEquals(operands);
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)filterOp) + " no MongoDB equivalent yet");
            }
        }
        return builder;
    }

    private List<String> convertOperandsToString(List<Object> rawOperands) {
        ArrayList<String> operands = new ArrayList<String>(rawOperands.size());
        for (Object rawOperand : rawOperands) {
            if (rawOperand == null) continue;
            operands.add(rawOperand.toString());
        }
        return operands;
    }
}

