/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.mongodb.filters;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.gora.filter.Filter;
import org.apache.gora.mongodb.filters.FilterFactory;
import org.apache.gora.mongodb.store.MongoStore;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.util.GoraException;
import org.apache.gora.util.ReflectionUtils;
import org.apache.hadoop.conf.Configuration;
import shaded.com.mongodb.DBObject;

public class MongoFilterUtil<K, T extends PersistentBase> {
    public static final String MONGO_FILTERS_DEFAULT_FACTORY = "org.apache.gora.mongodb.filters.DefaultFactory";
    public static final String MONGO_FILTER_FACTORIES_PARAMETER = "gora.mongodb.filter.factories";
    private static final Log LOG = LogFactory.getLog(MongoFilterUtil.class);
    private Map<String, FilterFactory<K, T>> factories = new LinkedHashMap<String, FilterFactory<K, T>>();

    public MongoFilterUtil(Configuration conf) throws GoraException {
        String[] factoryClassNames;
        for (String factoryClass : factoryClassNames = conf.getStrings(MONGO_FILTER_FACTORIES_PARAMETER, new String[]{MONGO_FILTERS_DEFAULT_FACTORY})) {
            try {
                FilterFactory factory = (FilterFactory)ReflectionUtils.newInstance(factoryClass);
                for (String filterClass : factory.getSupportedFilters()) {
                    this.factories.put(filterClass, factory);
                }
                factory.setFilterUtil(this);
            }
            catch (Exception e) {
                throw new GoraException(e);
            }
        }
    }

    public FilterFactory<K, T> getFactory(Filter<K, T> filter) {
        return this.factories.get(filter.getClass().getCanonicalName());
    }

    public boolean setFilter(DBObject query, Filter<K, T> filter, MongoStore<K, T> store) {
        FilterFactory<K, T> factory = this.getFactory(filter);
        if (factory == null) {
            LOG.warn((Object)("MongoDB remote filter factory not yet implemented for " + filter.getClass().getCanonicalName()));
            return false;
        }
        DBObject mongoFilter = factory.createFilter(filter, store);
        if (mongoFilter == null) {
            LOG.warn((Object)("MongoDB remote filter not yet implemented for " + filter.getClass().getCanonicalName()));
            return false;
        }
        query.putAll(mongoFilter);
        return true;
    }
}

