/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.mongodb.query;

import org.apache.gora.mongodb.store.MongoMapping;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.Query;
import org.apache.gora.query.impl.QueryBase;
import org.apache.gora.store.DataStore;
import shaded.com.mongodb.BasicDBObject;
import shaded.com.mongodb.DBObject;

public class MongoDBQuery<K, T extends PersistentBase>
extends QueryBase<K, T> {
    public MongoDBQuery() {
        super(null);
    }

    public MongoDBQuery(DataStore<K, T> dataStore) {
        super(dataStore);
    }

    public static DBObject toDBQuery(Query<?, ?> query) {
        BasicDBObject q = new BasicDBObject();
        if (query.getStartKey() != null && query.getEndKey() != null && query.getStartKey().equals(query.getEndKey())) {
            q.put("_id", query.getStartKey());
        } else {
            if (query.getStartKey() != null) {
                q.put("_id", new BasicDBObject("$gte", query.getStartKey()));
            }
            if (query.getEndKey() != null) {
                q.put("_id", new BasicDBObject("$lte", query.getEndKey()));
            }
        }
        return q;
    }

    public static DBObject toProjection(String[] fields, MongoMapping mapping) {
        BasicDBObject proj = new BasicDBObject();
        for (String k : fields) {
            String dbFieldName = mapping.getDocumentField(k);
            if (dbFieldName == null || dbFieldName.length() <= 0) continue;
            proj.put(dbFieldName, true);
        }
        return proj;
    }
}

