/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.mongodb.query;

import java.io.IOException;
import org.apache.gora.mongodb.store.MongoStore;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.Query;
import org.apache.gora.query.impl.ResultBase;
import org.apache.gora.store.DataStore;
import shaded.com.mongodb.DBCursor;
import shaded.com.mongodb.DBObject;

public class MongoDBResult<K, T extends PersistentBase>
extends ResultBase<K, T> {
    private DBCursor cursor;
    private int size;

    public MongoDBResult(DataStore<K, T> dataStore, Query<K, T> query) {
        super(dataStore, query);
    }

    @Override
    public float getProgress() throws IOException {
        if (this.cursor == null) {
            return 0.0f;
        }
        if (this.size == 0) {
            return 1.0f;
        }
        return (float)this.offset / (float)this.size;
    }

    @Override
    public void close() throws IOException {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    @Override
    protected boolean nextInner() throws IOException {
        if (!this.cursor.hasNext()) {
            return false;
        }
        DBObject obj = this.cursor.next();
        this.key = obj.get("_id");
        this.persistent = ((MongoStore)this.getDataStore()).newInstance(obj, this.getQuery().getFields());
        return this.persistent != null;
    }

    public void setCursor(DBCursor cursor) {
        this.cursor = cursor;
        this.size = cursor.size();
    }

    @Override
    public int size() {
        return this.size;
    }
}

