/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.mongodb.store;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoMapping {
    public static final Logger LOG = LoggerFactory.getLogger(MongoMapping.class);
    private Pattern validMongoDocumentField = Pattern.compile("[a-z0-9\\-]+", 2);
    private String collectionName;
    private HashMap<String, String> classToDocument = new HashMap();
    private HashMap<String, String> documentToClass = new HashMap();
    private HashMap<String, DocumentFieldType> documentFields = new HashMap();

    public void renameCollection(String oldName, String newName) {
        this.collectionName = newName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collName) {
        this.collectionName = collName;
    }

    private void newDocumentField(String name, DocumentFieldType type) {
        String[] breadcrumb = name.split("\\.");
        StringBuilder partialFieldName = new StringBuilder();
        for (int i = 0; i < breadcrumb.length - 1; ++i) {
            String f = breadcrumb[i];
            if (!this.isValidFieldName(f)) {
                throw new IllegalArgumentException("'" + f + "' is an invalid field name for a Mongo document");
            }
            partialFieldName.append(f);
            String intermediateFieldName = partialFieldName.toString();
            if (this.documentFields.containsKey(intermediateFieldName)) {
                if (!ImmutableList.of((Object)((Object)DocumentFieldType.DOCUMENT), (Object)((Object)DocumentFieldType.LIST)).contains((Object)this.documentFields.get(intermediateFieldName))) {
                    throw new IllegalStateException("The field '" + intermediateFieldName + "' is already registered in a type not compatible with the new definition of field '" + name + "'.");
                }
            } else {
                this.documentFields.put(intermediateFieldName, DocumentFieldType.DOCUMENT);
            }
            partialFieldName.append(".");
        }
        if (this.documentFields.containsKey(name) && this.documentFields.get(name) != type) {
            throw new IllegalStateException("The field '" + name + "' is already registered with a different type.");
        }
        this.documentFields.put(name, type);
    }

    private boolean isValidFieldName(String f) {
        return this.validMongoDocumentField.matcher(f).matches();
    }

    public void addClassField(String classFieldName, String docFieldName, String fieldType) {
        try {
            this.newDocumentField(docFieldName, DocumentFieldType.valueOf(fieldType.toUpperCase(Locale.getDefault())));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Declared '" + fieldType + "' for class field '" + classFieldName + "' is not supported by MongoMapping");
        }
        if (this.classToDocument.containsKey(classFieldName)) {
            if (!this.classToDocument.get(classFieldName).equals(docFieldName)) {
                throw new IllegalStateException("The class field '" + classFieldName + "' is already registered in the mapping with the document field '" + this.classToDocument.get(classFieldName) + " which differs from the new one '" + docFieldName + "'.");
            }
        } else {
            this.classToDocument.put(classFieldName, docFieldName);
            this.documentToClass.put(docFieldName, classFieldName);
        }
    }

    public String getDocumentField(String field) {
        return this.classToDocument.get(field);
    }

    protected DocumentFieldType getDocumentFieldType(String field) {
        return this.documentFields.get(field);
    }

    public static enum DocumentFieldType {
        BINARY,
        BOOLEAN,
        INT32,
        INT64,
        DOUBLE,
        STRING,
        DATE,
        LIST,
        DOCUMENT,
        OBJECTID;

    }
}

