/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.mongodb.store;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.gora.mongodb.store.MongoMapping;
import org.apache.gora.mongodb.store.MongoStore;
import org.apache.gora.persistency.impl.PersistentBase;
import shaded.org.jdom.Document;
import shaded.org.jdom.Element;
import shaded.org.jdom.input.SAXBuilder;

public class MongoMappingBuilder<K, T extends PersistentBase> {
    static final String TAG_DOCUMENT = "document";
    static final String ATT_COLLECTION = "collection";
    static final String STAG_DOCUMENT_FIELD = "field";
    static final String ATT_NAME = "name";
    static final String ATT_TYPE = "type";
    static final String STAG_SUBDOCUMENT = "subdocument";
    static final String TAG_CLASS = "class";
    static final String ATT_KEYCLASS = "keyClass";
    static final String ATT_DOCUMENT = "document";
    static final String TAG_FIELD = "field";
    static final String ATT_FIELD = "docfield";
    private final MongoStore<K, T> dataStore;
    private MongoMapping mapping;

    public MongoMappingBuilder(MongoStore<K, T> store) {
        this.dataStore = store;
        this.mapping = new MongoMapping();
    }

    public MongoMapping build() {
        if (this.mapping.getCollectionName() == null) {
            throw new IllegalStateException("A collection is not specified");
        }
        return this.mapping;
    }

    protected void fromFile(String uri) throws IOException {
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            InputStream is = this.getClass().getResourceAsStream(uri);
            if (is == null) {
                String msg = "Unable to load the mapping from resource '" + uri + "' as it does not appear to exist! Trying local file.";
                MongoStore.LOG.warn(msg);
                is = new FileInputStream(uri);
            }
            Document doc = saxBuilder.build(is);
            Element root = doc.getRootElement();
            List classElements = root.getChildren(TAG_CLASS);
            for (Element classElement : classElements) {
                Class persistentClass = this.dataStore.getPersistentClass();
                Class keyClass = this.dataStore.getKeyClass();
                if (!this.haveKeyClass(keyClass, classElement) || !this.havePersistentClass(persistentClass, classElement)) continue;
                this.loadPersistentClass(classElement, persistentClass);
                break;
            }
        }
        catch (IOException ex) {
            MongoStore.LOG.error(ex.getMessage());
            MongoStore.LOG.error(ex.getStackTrace().toString());
            throw ex;
        }
        catch (Exception ex) {
            MongoStore.LOG.error(ex.getMessage());
            MongoStore.LOG.error(ex.getStackTrace().toString());
            throw new IOException(ex);
        }
    }

    private boolean havePersistentClass(Class<T> persistentClass, Element classElement) {
        return classElement.getAttributeValue(ATT_NAME).equals(persistentClass.getName());
    }

    private boolean haveKeyClass(Class<K> keyClass, Element classElement) {
        return classElement.getAttributeValue(ATT_KEYCLASS).equals(keyClass.getName());
    }

    protected void loadPersistentClass(Element classElement, Class<T> pPersistentClass) {
        String docNameFromMapping = classElement.getAttributeValue("document");
        String collName = this.dataStore.getSchemaName(docNameFromMapping, pPersistentClass);
        this.mapping.setCollectionName(collName);
        if (!collName.equals(docNameFromMapping)) {
            MongoStore.LOG.info("Keyclass and nameclass match but mismatching table names  mappingfile schema is '" + docNameFromMapping + "' vs actual schema '" + collName + "' , assuming they are the same.");
            if (docNameFromMapping != null) {
                this.mapping.renameCollection(docNameFromMapping, collName);
            }
        }
        List fields = classElement.getChildren("field");
        for (Element field : fields) {
            this.mapping.addClassField(field.getAttributeValue(ATT_NAME), field.getAttributeValue(ATT_FIELD), field.getAttributeValue(ATT_TYPE));
        }
    }
}

