/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.mongodb.store;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.DatatypeConverter;
import org.apache.avro.Schema;
import org.apache.avro.util.Utf8;
import org.apache.gora.mongodb.filters.MongoFilterUtil;
import org.apache.gora.mongodb.query.MongoDBQuery;
import org.apache.gora.mongodb.query.MongoDBResult;
import org.apache.gora.mongodb.store.MongoMapping;
import org.apache.gora.mongodb.store.MongoMappingBuilder;
import org.apache.gora.mongodb.store.MongoStoreParameters;
import org.apache.gora.mongodb.utils.BSONDecorator;
import org.apache.gora.mongodb.utils.GoraDBEncoder;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.persistency.impl.BeanFactoryImpl;
import org.apache.gora.persistency.impl.DirtyListWrapper;
import org.apache.gora.persistency.impl.DirtyMapWrapper;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.PartitionQuery;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.query.impl.PartitionQueryImpl;
import org.apache.gora.store.impl.DataStoreBase;
import org.apache.gora.util.AvroUtils;
import org.apache.gora.util.ClassLoadingUtils;
import org.apache.gora.util.GoraException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.mongodb.AuthenticationMechanism;
import shaded.com.mongodb.BasicDBList;
import shaded.com.mongodb.BasicDBObject;
import shaded.com.mongodb.DB;
import shaded.com.mongodb.DBCollection;
import shaded.com.mongodb.DBCursor;
import shaded.com.mongodb.DBObject;
import shaded.com.mongodb.MongoClient;
import shaded.com.mongodb.MongoClientOptions;
import shaded.com.mongodb.MongoCredential;
import shaded.com.mongodb.ReadPreference;
import shaded.com.mongodb.ServerAddress;
import shaded.com.mongodb.WriteConcern;
import shaded.com.mongodb.WriteResult;
import shaded.org.bson.types.ObjectId;

public class MongoStore<K, T extends PersistentBase>
extends DataStoreBase<K, T> {
    public static final Logger LOG = LoggerFactory.getLogger(MongoStore.class);
    public static final String DEFAULT_MAPPING_FILE = "/gora-mongodb-mapping.xml";
    private static ConcurrentHashMap<String, MongoClient> mapsOfClients = new ConcurrentHashMap();
    private DB mongoClientDB;
    private DBCollection mongoClientColl;
    private MongoMapping mapping = new MongoMapping();
    private MongoFilterUtil<K, T> filterUtil;

    @Override
    public void initialize(Class<K> keyClass, Class<T> pPersistentClass, Properties properties) throws GoraException {
        try {
            LOG.debug("Initializing MongoDB store");
            MongoStoreParameters parameters = MongoStoreParameters.load(properties, this.getConf());
            super.initialize(keyClass, pPersistentClass, properties);
            this.filterUtil = new MongoFilterUtil(this.getConf());
            MongoMappingBuilder builder = new MongoMappingBuilder(this);
            LOG.debug("Initializing Mongo store with mapping {}.", new Object[]{parameters.getMappingFile()});
            builder.fromFile(parameters.getMappingFile());
            this.mapping = builder.build();
            this.mongoClientDB = this.getDB(parameters);
            this.mongoClientColl = this.mongoClientDB.getCollection(this.mapping.getCollectionName());
            LOG.info("Initialized Mongo store for database {} of {}.", new Object[]{parameters.getDbname(), parameters.getServers()});
        }
        catch (GoraException e) {
            throw e;
        }
        catch (IOException e) {
            LOG.error("Error while initializing MongoDB store", (Throwable)e);
            throw new GoraException(e);
        }
    }

    private MongoClient getClient(MongoStoreParameters params) throws UnknownHostException {
        MongoClientOptions.Builder optBuilder = new MongoClientOptions.Builder().dbEncoderFactory(GoraDBEncoder.FACTORY);
        if (params.getReadPreference() != null) {
            optBuilder.readPreference(ReadPreference.valueOf(params.getReadPreference()));
        }
        if (params.getWriteConcern() != null) {
            optBuilder.writeConcern(WriteConcern.valueOf(params.getWriteConcern()));
        }
        ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
        if (params.getLogin() != null && params.getSecret() != null) {
            credentials.add(this.createCredential(params.getAuthenticationType(), params.getLogin(), params.getDbname(), params.getSecret()));
        }
        ArrayList<ServerAddress> addrs = new ArrayList<ServerAddress>();
        Iterable serversArray = Splitter.on((String)",").split((CharSequence)params.getServers());
        if (serversArray != null) {
            for (String server : serversArray) {
                Iterator paramsIterator = Splitter.on((String)":").trimResults().split((CharSequence)server).iterator();
                if (!paramsIterator.hasNext()) {
                    addrs.add(new ServerAddress());
                    continue;
                }
                String host = (String)paramsIterator.next();
                if (paramsIterator.hasNext()) {
                    String port = (String)paramsIterator.next();
                    addrs.add(new ServerAddress(host, Integer.parseInt(port)));
                    continue;
                }
                addrs.add(new ServerAddress(host));
            }
        }
        return new MongoClient(addrs, credentials, optBuilder.build());
    }

    private MongoCredential createCredential(String authenticationType, String username, String database, String password) {
        MongoCredential credential = null;
        credential = AuthenticationMechanism.PLAIN.getMechanismName().equals(authenticationType) ? MongoCredential.createPlainCredential(username, database, password.toCharArray()) : (AuthenticationMechanism.SCRAM_SHA_1.getMechanismName().equals(authenticationType) ? MongoCredential.createScramSha1Credential(username, database, password.toCharArray()) : (AuthenticationMechanism.MONGODB_CR.getMechanismName().equals(authenticationType) ? MongoCredential.createMongoCRCredential(username, database, password.toCharArray()) : (AuthenticationMechanism.GSSAPI.getMechanismName().equals(authenticationType) ? MongoCredential.createGSSAPICredential(username) : (AuthenticationMechanism.MONGODB_X509.getMechanismName().equals(authenticationType) ? MongoCredential.createMongoX509Credential(username) : MongoCredential.createCredential(username, database, password.toCharArray())))));
        return credential;
    }

    private DB getDB(MongoStoreParameters parameters) throws UnknownHostException {
        if (!mapsOfClients.containsKey(parameters.getServers())) {
            mapsOfClients.put(parameters.getServers(), this.getClient(parameters));
        }
        DB db = mapsOfClients.get(parameters.getServers()).getDB(parameters.getDbname());
        return db;
    }

    public MongoMapping getMapping() {
        return this.mapping;
    }

    @Override
    public String getSchemaName() {
        return this.mapping.getCollectionName();
    }

    @Override
    public String getSchemaName(String mappingSchemaName, Class<?> persistentClass) {
        return super.getSchemaName(mappingSchemaName, persistentClass);
    }

    @Override
    public void createSchema() throws GoraException {
        if (this.mongoClientDB == null) {
            throw new GoraException("Impossible to create the schema as no database has been selected.");
        }
        if (this.schemaExists()) {
            return;
        }
        try {
            this.mongoClientColl = this.mongoClientDB.createCollection(this.mapping.getCollectionName(), new BasicDBObject());
            this.mongoClientColl.setDBEncoderFactory(GoraDBEncoder.FACTORY);
            LOG.debug("Collection {} has been created for Mongo instance {}.", new Object[]{this.mapping.getCollectionName(), this.mongoClientDB.getMongo()});
        }
        catch (Exception e) {
            throw new GoraException(e);
        }
    }

    @Override
    public void deleteSchema() throws GoraException {
        if (this.mongoClientColl == null) {
            throw new GoraException("Impossible to delete the schema as no schema is selected.");
        }
        try {
            this.mongoClientColl.drop();
            LOG.debug("Collection {} has been dropped for Mongo instance {}.", new Object[]{this.mongoClientColl.getFullName(), this.mongoClientDB.getMongo()});
        }
        catch (Exception e) {
            throw new GoraException(e);
        }
    }

    @Override
    public boolean schemaExists() throws GoraException {
        try {
            return this.mongoClientDB.collectionExists(this.mapping.getCollectionName());
        }
        catch (Exception e) {
            throw new GoraException(e);
        }
    }

    @Override
    public void flush() throws GoraException {
        try {
            for (MongoClient client : mapsOfClients.values()) {
                client.fsync(false);
                LOG.debug("Forced synced of database for Mongo instance {}.", new Object[]{client});
            }
        }
        catch (Exception e) {
            throw new GoraException(e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public T get(K key, String[] fields) throws GoraException {
        try {
            String[] dbFields = this.getFieldsToQuery(fields);
            BasicDBObject q = new BasicDBObject("_id", key);
            BasicDBObject proj = new BasicDBObject();
            for (String field : dbFields) {
                String docf = this.mapping.getDocumentField(field);
                if (docf == null) continue;
                proj.put(docf, true);
            }
            DBObject res = this.mongoClientColl.findOne((DBObject)q, (DBObject)proj);
            return this.newInstance(res, dbFields);
        }
        catch (Exception e) {
            throw new GoraException(e);
        }
    }

    @Override
    public boolean exists(K key) throws GoraException {
        try {
            BasicDBObject q = new BasicDBObject("_id", key);
            BasicDBObject proj = new BasicDBObject();
            DBObject res = this.mongoClientColl.findOne((DBObject)q, (DBObject)proj);
            return res != null;
        }
        catch (Exception e) {
            throw new GoraException(e);
        }
    }

    @Override
    public void put(K key, T obj) throws GoraException {
        try {
            if (((PersistentBase)obj).isDirty()) {
                this.performPut(key, obj);
            } else {
                LOG.info("Ignored putting object {} in the store as it is neither new, neither dirty.", new Object[]{obj});
            }
        }
        catch (Exception e) {
            throw new GoraException(e);
        }
    }

    private void performPut(K key, T obj) {
        BasicDBObject qUpdateUnset;
        BasicDBObject qSel = new BasicDBObject("_id", key);
        BasicDBObject qUpdate = new BasicDBObject();
        BasicDBObject qUpdateSet = this.newUpdateSetInstance(obj);
        if (qUpdateSet.size() > 0) {
            qUpdate.put("$set", qUpdateSet);
        }
        if ((qUpdateUnset = this.newUpdateUnsetInstance(obj)).size() > 0) {
            qUpdate.put("$unset", qUpdateUnset);
        }
        if (!qUpdate.isEmpty()) {
            this.mongoClientColl.update(qSel, qUpdate, true, false);
            ((PersistentBase)obj).clearDirty();
        } else {
            LOG.debug("No update to perform, skip {}", key);
        }
    }

    @Override
    public boolean delete(K key) throws GoraException {
        try {
            BasicDBObject removeKey = new BasicDBObject("_id", key);
            WriteResult writeResult = this.mongoClientColl.remove(removeKey);
            return writeResult != null && writeResult.getN() > 0;
        }
        catch (Exception e) {
            throw new GoraException(e);
        }
    }

    @Override
    public long deleteByQuery(Query<K, T> query) throws GoraException {
        try {
            DBObject q = MongoDBQuery.toDBQuery(query);
            WriteResult writeResult = this.mongoClientColl.remove(q);
            if (writeResult != null) {
                return writeResult.getN();
            }
            return 0L;
        }
        catch (Exception e) {
            throw new GoraException(e);
        }
    }

    @Override
    public Result<K, T> execute(Query<K, T> query) throws GoraException {
        try {
            boolean succeeded;
            String[] fields = this.getFieldsToQuery(query.getFields());
            DBObject q = MongoDBQuery.toDBQuery(query);
            DBObject p = MongoDBQuery.toProjection(fields, this.mapping);
            if (query.getFilter() != null && (succeeded = this.filterUtil.setFilter(q, query.getFilter(), this))) {
                query.setLocalFilterEnabled(false);
            }
            DBCursor cursor = this.mongoClientColl.find(q, p);
            if (query.getLimit() > 0L) {
                cursor = cursor.limit((int)query.getLimit());
            }
            cursor.batchSize(100);
            cursor.addOption(16);
            MongoDBResult<K, T> mongoResult = new MongoDBResult<K, T>(this, query);
            mongoResult.setCursor(cursor);
            return mongoResult;
        }
        catch (Exception e) {
            throw new GoraException(e);
        }
    }

    @Override
    public Query<K, T> newQuery() {
        MongoDBQuery query = new MongoDBQuery(this);
        query.setFields(this.getFieldsToQuery(null));
        return query;
    }

    @Override
    public List<PartitionQuery<K, T>> getPartitions(Query<K, T> query) throws IOException {
        ArrayList<PartitionQuery<K, T>> partitions = new ArrayList<PartitionQuery<K, T>>();
        PartitionQueryImpl<K, T> partitionQuery = new PartitionQueryImpl<K, T>(query, new String[0]);
        partitionQuery.setConf(this.getConf());
        partitions.add(partitionQuery);
        return partitions;
    }

    public T newInstance(DBObject obj, String[] fields) throws GoraException {
        String[] dbFields;
        if (obj == null) {
            return null;
        }
        BSONDecorator easybson = new BSONDecorator(obj);
        Persistent persistent = this.newPersistent();
        for (String f : dbFields = this.getFieldsToQuery(fields)) {
            String docf = this.mapping.getDocumentField(f);
            if (docf == null || !easybson.containsField(docf)) continue;
            MongoMapping.DocumentFieldType storeType = this.mapping.getDocumentFieldType(docf);
            Schema.Field field = (Schema.Field)this.fieldMap.get(f);
            Schema fieldSchema = field.schema();
            LOG.debug("Load from DBObject (MAIN), field:{}, schemaType:{}, docField:{}, storeType:{}", new Object[]{field.name(), fieldSchema.getType(), docf, storeType});
            Object result = this.fromDBObject(fieldSchema, storeType, field, docf, easybson);
            persistent.put(field.pos(), result);
        }
        ((PersistentBase)persistent).clearDirty();
        return (T)persistent;
    }

    private Object fromDBObject(Schema fieldSchema, MongoMapping.DocumentFieldType storeType, Schema.Field field, String docf, BSONDecorator easybson) throws GoraException {
        Object result = null;
        switch (fieldSchema.getType()) {
            case MAP: {
                result = this.fromMongoMap(docf, fieldSchema, easybson, field);
                break;
            }
            case ARRAY: {
                result = this.fromMongoList(docf, fieldSchema, easybson, field);
                break;
            }
            case RECORD: {
                BasicDBObject rec = easybson.getDBObject(docf);
                if (rec == null) {
                    result = null;
                    break;
                }
                result = this.fromMongoRecord(fieldSchema, docf, rec);
                break;
            }
            case BOOLEAN: {
                result = easybson.getBoolean(docf);
                break;
            }
            case DOUBLE: {
                result = easybson.getDouble(docf);
                break;
            }
            case FLOAT: {
                result = Float.valueOf(easybson.getDouble(docf).floatValue());
                break;
            }
            case INT: {
                result = easybson.getInt(docf);
                break;
            }
            case LONG: {
                result = easybson.getLong(docf);
                break;
            }
            case STRING: {
                result = this.fromMongoString(storeType, docf, easybson);
                break;
            }
            case ENUM: {
                result = AvroUtils.getEnumValue(fieldSchema, easybson.getUtf8String(docf).toString());
                break;
            }
            case BYTES: 
            case FIXED: {
                result = easybson.getBytes(docf);
                break;
            }
            case NULL: {
                result = null;
                break;
            }
            case UNION: {
                result = this.fromMongoUnion(fieldSchema, storeType, field, docf, easybson);
                break;
            }
            default: {
                LOG.warn("Unable to read {}", (Object)docf);
            }
        }
        return result;
    }

    private Object fromMongoUnion(Schema fieldSchema, MongoMapping.DocumentFieldType storeType, Schema.Field field, String docf, BSONDecorator easybson) throws GoraException {
        Schema.Type type1;
        Schema.Type type0 = ((Schema)fieldSchema.getTypes().get(0)).getType();
        if (type0.equals((Object)(type1 = ((Schema)fieldSchema.getTypes().get(1)).getType())) || !type0.equals((Object)Schema.Type.NULL) && !type1.equals((Object)Schema.Type.NULL)) {
            throw new IllegalStateException("MongoStore doesn't support 3 types union field yet. Please update your mapping");
        }
        Schema innerSchema = (Schema)fieldSchema.getTypes().get(1);
        LOG.debug("Load from DBObject (UNION), schemaType:{}, docField:{}, storeType:{}", new Object[]{innerSchema.getType(), docf, storeType});
        Object result = this.fromDBObject(innerSchema, storeType, field, docf, easybson);
        return result;
    }

    private Object fromMongoRecord(Schema fieldSchema, String docf, DBObject rec) throws GoraException {
        BSONDecorator innerBson = new BSONDecorator(rec);
        Class<?> clazz = null;
        try {
            clazz = ClassLoadingUtils.loadClass(fieldSchema.getFullName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        PersistentBase record = (PersistentBase)new BeanFactoryImpl(this.keyClass, clazz).newPersistent();
        for (Schema.Field recField : fieldSchema.getFields()) {
            Schema innerSchema = recField.schema();
            MongoMapping.DocumentFieldType innerStoreType = this.mapping.getDocumentFieldType(innerSchema.getName());
            String innerDocField = this.mapping.getDocumentField(recField.name()) != null ? this.mapping.getDocumentField(recField.name()) : recField.name();
            String fieldPath = docf + "." + innerDocField;
            LOG.debug("Load from DBObject (RECORD), field:{}, schemaType:{}, docField:{}, storeType:{}", new Object[]{recField.name(), innerSchema.getType(), fieldPath, innerStoreType});
            record.put(recField.pos(), this.fromDBObject(innerSchema, innerStoreType, recField, innerDocField, innerBson));
        }
        PersistentBase result = record;
        return result;
    }

    Object fromMongoList(String docf, Schema fieldSchema, BSONDecorator easybson, Schema.Field f) throws GoraException {
        BasicDBList list = easybson.getDBList(docf);
        ArrayList<Object> rlist = new ArrayList<Object>();
        if (list == null) {
            return new DirtyListWrapper(rlist);
        }
        for (Object item : list) {
            MongoMapping.DocumentFieldType storeType = this.mapping.getDocumentFieldType(docf);
            Object o = this.fromDBObject(fieldSchema.getElementType(), storeType, f, "item", new BSONDecorator(new BasicDBObject("item", item)));
            rlist.add(o);
        }
        return new DirtyListWrapper(rlist);
    }

    Object fromMongoMap(String docf, Schema fieldSchema, BSONDecorator easybson, Schema.Field f) throws GoraException {
        BasicDBObject map = easybson.getDBObject(docf);
        HashMap<Utf8, Object> rmap = new HashMap<Utf8, Object>();
        if (map == null) {
            return new DirtyMapWrapper(rmap);
        }
        for (Map.Entry e : map.entrySet()) {
            String mapKey = (String)e.getKey();
            String decodedMapKey = this.decodeFieldKey(mapKey);
            MongoMapping.DocumentFieldType storeType = this.mapping.getDocumentFieldType(docf);
            Object o = this.fromDBObject(fieldSchema.getValueType(), storeType, f, mapKey, new BSONDecorator(map));
            rmap.put(new Utf8(decodedMapKey), o);
        }
        return new DirtyMapWrapper(rmap);
    }

    private Object fromMongoString(MongoMapping.DocumentFieldType storeType, String docf, BSONDecorator easybson) {
        Utf8 result;
        if (storeType == MongoMapping.DocumentFieldType.OBJECTID) {
            Object bin = easybson.get(docf);
            if (bin instanceof String) {
                ObjectId id = new ObjectId((String)bin);
                result = new Utf8(id.toString());
            } else {
                result = new Utf8(bin.toString());
            }
        } else if (storeType == MongoMapping.DocumentFieldType.DATE) {
            Object bin = easybson.get(docf);
            if (bin instanceof Date) {
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.getDefault());
                calendar.setTime((Date)bin);
                result = new Utf8(DatatypeConverter.printDateTime((Calendar)calendar));
            } else {
                result = new Utf8(bin.toString());
            }
        } else {
            result = easybson.getUtf8String(docf);
        }
        return result;
    }

    private BasicDBObject newUpdateSetInstance(T persistent) {
        BasicDBObject result = new BasicDBObject();
        for (Schema.Field f : persistent.getSchema().getFields()) {
            if (!((PersistentBase)persistent).isDirty(f.pos()) || persistent.get(f.pos()) == null) continue;
            String docf = this.mapping.getDocumentField(f.name());
            Object value = persistent.get(f.pos());
            MongoMapping.DocumentFieldType storeType = this.mapping.getDocumentFieldType(docf);
            LOG.debug("Transform value to DBObject (MAIN), docField:{}, schemaType:{}, storeType:{}", new Object[]{docf, f.schema().getType(), storeType});
            Object o = this.toDBObject(docf, f.schema(), f.schema().getType(), storeType, value);
            result.put(docf, o);
        }
        return result;
    }

    private BasicDBObject newUpdateUnsetInstance(T persistent) {
        BasicDBObject result = new BasicDBObject();
        for (Schema.Field f : persistent.getSchema().getFields()) {
            if (!((PersistentBase)persistent).isDirty(f.pos()) || persistent.get(f.pos()) != null) continue;
            String docf = this.mapping.getDocumentField(f.name());
            Object value = persistent.get(f.pos());
            MongoMapping.DocumentFieldType storeType = this.mapping.getDocumentFieldType(docf);
            LOG.debug("Transform value to DBObject (MAIN), docField:{}, schemaType:{}, storeType:{}", new Object[]{docf, f.schema().getType(), storeType});
            Object o = this.toDBObject(docf, f.schema(), f.schema().getType(), storeType, value);
            result.put(docf, o);
        }
        return result;
    }

    private Object toDBObject(String docf, Schema fieldSchema, Schema.Type fieldType, MongoMapping.DocumentFieldType storeType, Object value) {
        Object result = null;
        switch (fieldType) {
            case MAP: {
                if (storeType != null && storeType != MongoMapping.DocumentFieldType.DOCUMENT) {
                    throw new IllegalStateException("Field " + fieldSchema.getType() + ": to store a Gora 'map', target Mongo mapping have to be of 'document' type");
                }
                Schema valueSchema = fieldSchema.getValueType();
                result = this.mapToMongo(docf, (Map)value, valueSchema, valueSchema.getType());
                break;
            }
            case ARRAY: {
                if (storeType != null && storeType != MongoMapping.DocumentFieldType.LIST) {
                    throw new IllegalStateException("Field " + fieldSchema.getType() + ": To store a Gora 'array', target Mongo mapping have to be of 'list' type");
                }
                Schema elementSchema = fieldSchema.getElementType();
                result = this.listToMongo(docf, (List)value, elementSchema, elementSchema.getType());
                break;
            }
            case BYTES: {
                if (value == null) break;
                result = ((ByteBuffer)value).array();
                break;
            }
            case BOOLEAN: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: {
                result = value;
                break;
            }
            case STRING: {
                result = this.stringToMongo(fieldSchema, storeType, value);
                break;
            }
            case ENUM: {
                if (value == null) break;
                result = value.toString();
                break;
            }
            case RECORD: {
                if (value == null) break;
                result = this.recordToMongo(docf, fieldSchema, value);
                break;
            }
            case UNION: {
                result = this.unionToMongo(docf, fieldSchema, storeType, value);
                break;
            }
            case FIXED: {
                result = value;
                break;
            }
            default: {
                LOG.error("Unknown field type: {}", (Object)fieldSchema.getType());
            }
        }
        return result;
    }

    private Object unionToMongo(String docf, Schema fieldSchema, MongoMapping.DocumentFieldType storeType, Object value) {
        Schema.Type type1;
        Schema.Type type0 = ((Schema)fieldSchema.getTypes().get(0)).getType();
        if (type0.equals((Object)(type1 = ((Schema)fieldSchema.getTypes().get(1)).getType())) || !type0.equals((Object)Schema.Type.NULL) && !type1.equals((Object)Schema.Type.NULL)) {
            throw new IllegalStateException("MongoStore doesn't support 3 types union field yet. Please update your mapping");
        }
        Schema innerSchema = (Schema)fieldSchema.getTypes().get(1);
        LOG.debug("Transform value to DBObject (UNION), schemaType:{}, type1:{}, storeType:{}", new Object[]{innerSchema.getType(), type1, storeType});
        Object result = this.toDBObject(docf, innerSchema, type1, storeType, value);
        return result;
    }

    private BasicDBObject recordToMongo(String docf, Schema fieldSchema, Object value) {
        BasicDBObject record = new BasicDBObject();
        for (Schema.Field member : fieldSchema.getFields()) {
            Object innerValue = ((PersistentBase)value).get(member.pos());
            String innerDoc = this.mapping.getDocumentField(member.name());
            Schema.Type innerType = member.schema().getType();
            MongoMapping.DocumentFieldType innerStoreType = this.mapping.getDocumentFieldType(innerDoc);
            LOG.debug("Transform value to DBObject (RECORD), docField:{}, schemaType:{}, storeType:{}", new Object[]{member.name(), member.schema().getType(), innerStoreType});
            record.put(member.name(), this.toDBObject(docf, member.schema(), innerType, innerStoreType, innerValue));
        }
        return record;
    }

    private Object stringToMongo(Schema fieldSchema, MongoMapping.DocumentFieldType storeType, Object value) {
        Object result = null;
        if (storeType == MongoMapping.DocumentFieldType.OBJECTID) {
            if (value != null) {
                ObjectId id;
                try {
                    id = new ObjectId(value.toString());
                }
                catch (IllegalArgumentException e1) {
                    throw new IllegalStateException("Field " + fieldSchema.getType() + ": Invalid string: unable to convert to ObjectId");
                }
                result = id;
            }
        } else if (storeType == MongoMapping.DocumentFieldType.DATE) {
            if (value != null) {
                Calendar calendar = null;
                try {
                    calendar = DatatypeConverter.parseDateTime((String)value.toString());
                }
                catch (IllegalArgumentException e1) {
                    try {
                        calendar = DatatypeConverter.parseDate((String)value.toString());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (calendar == null) {
                    throw new IllegalStateException("Field " + fieldSchema.getType() + ": Invalid date format '" + value + "'");
                }
                result = calendar.getTime();
            }
        } else if (value != null) {
            result = value.toString();
        }
        return result;
    }

    private BasicDBObject mapToMongo(String docf, Map<CharSequence, ?> value, Schema fieldSchema, Schema.Type fieldType) {
        BasicDBObject map = new BasicDBObject();
        if (value == null) {
            return map;
        }
        for (Map.Entry<CharSequence, ?> e : value.entrySet()) {
            String mapKey = e.getKey().toString();
            String encodedMapKey = this.encodeFieldKey(mapKey);
            Object mapValue = e.getValue();
            MongoMapping.DocumentFieldType storeType = this.mapping.getDocumentFieldType(docf);
            Object result = this.toDBObject(docf, fieldSchema, fieldType, storeType, mapValue);
            map.put(encodedMapKey, result);
        }
        return map;
    }

    private BasicDBList listToMongo(String docf, Collection<?> array, Schema fieldSchema, Schema.Type fieldType) {
        BasicDBList list = new BasicDBList();
        if (array == null) {
            return list;
        }
        for (Object item : array) {
            MongoMapping.DocumentFieldType storeType = this.mapping.getDocumentFieldType(docf);
            Object result = this.toDBObject(docf, fieldSchema, fieldType, storeType, item);
            list.add(result);
        }
        return list;
    }

    public String encodeFieldKey(String key) {
        if (key == null) {
            return null;
        }
        return key.replace(".", "\u00b7");
    }

    public String decodeFieldKey(String key) {
        if (key == null) {
            return null;
        }
        return key.replace("\u00b7", ".");
    }
}

