/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.mongodb.store;

import java.util.Properties;
import org.apache.gora.mongodb.store.MongoStore;
import org.apache.hadoop.conf.Configuration;

public class MongoStoreParameters {
    public static final String PROP_OVERRIDING = "gora.mongodb.override_hadoop_configuration";
    public static final String PROP_MAPPING_FILE = "gora.mongodb.mapping.file";
    public static final String PROP_MONGO_SERVERS = "gora.mongodb.servers";
    public static final String PROP_MONGO_LOGIN = "gora.mongodb.login";
    public static final String PROP_MONGO_AUTHENTICATION_TYPE = "gora.mongodb.authentication.type";
    public static final String PROP_MONGO_SECRET = "gora.mongodb.secret";
    public static final String PROP_MONGO_READPREFERENCE = "gora.mongodb.readpreference";
    public static final String PROP_MONGO_WRITECONCERN = "gora.mongodb.writeconcern";
    public static final String PROP_MONGO_DB = "gora.mongodb.db";
    private final String mappingFile;
    private final String servers;
    private final String authenticationType;
    private final String dbname;
    private final String login;
    private final String secret;
    private final String readPreference;
    private final String writeConcern;

    private MongoStoreParameters(String mappingFile, String servers, String dbname, String authenticationType, String login, String secret, String readPreference, String writeConcern) {
        this.mappingFile = mappingFile;
        this.servers = servers;
        this.dbname = dbname;
        this.authenticationType = authenticationType;
        this.login = login;
        this.secret = secret;
        this.readPreference = readPreference;
        this.writeConcern = writeConcern;
    }

    public String getMappingFile() {
        return this.mappingFile;
    }

    public String getServers() {
        return this.servers;
    }

    public String getDbname() {
        return this.dbname;
    }

    public String getLogin() {
        return this.login;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getReadPreference() {
        return this.readPreference;
    }

    public String getWriteConcern() {
        return this.writeConcern;
    }

    public static MongoStoreParameters load(Properties properties, Configuration conf) {
        String vPropMappingFile = properties.getProperty(PROP_MAPPING_FILE, "/gora-mongodb-mapping.xml");
        String vPropMongoServers = properties.getProperty(PROP_MONGO_SERVERS);
        String vPropMongoAuthenticationType = properties.getProperty(PROP_MONGO_AUTHENTICATION_TYPE);
        String vPropMongoLogin = properties.getProperty(PROP_MONGO_LOGIN);
        String vPropMongoSecret = properties.getProperty(PROP_MONGO_SECRET);
        String vPropMongoDb = properties.getProperty(PROP_MONGO_DB);
        String vPropMongoRead = properties.getProperty(PROP_MONGO_READPREFERENCE);
        String vPropMongoWrite = properties.getProperty(PROP_MONGO_WRITECONCERN);
        String overrideHadoop = properties.getProperty(PROP_OVERRIDING);
        if (!Boolean.parseBoolean(overrideHadoop)) {
            MongoStore.LOG.debug("Hadoop configuration has priority.");
            vPropMappingFile = conf.get(PROP_MAPPING_FILE, vPropMappingFile);
            vPropMongoServers = conf.get(PROP_MONGO_SERVERS, vPropMongoServers);
            vPropMongoAuthenticationType = conf.get(PROP_MONGO_AUTHENTICATION_TYPE, vPropMongoAuthenticationType);
            vPropMongoLogin = conf.get(PROP_MONGO_LOGIN, vPropMongoLogin);
            vPropMongoSecret = conf.get(PROP_MONGO_SECRET, vPropMongoSecret);
            vPropMongoDb = conf.get(PROP_MONGO_DB, vPropMongoDb);
            vPropMongoRead = conf.get(PROP_MONGO_READPREFERENCE, vPropMongoRead);
            vPropMongoWrite = conf.get(PROP_MONGO_WRITECONCERN, vPropMongoWrite);
        }
        return new MongoStoreParameters(vPropMappingFile, vPropMongoServers, vPropMongoDb, vPropMongoAuthenticationType, vPropMongoLogin, vPropMongoSecret, vPropMongoRead, vPropMongoWrite);
    }
}

