/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.mongodb.utils;

import java.nio.ByteBuffer;
import java.util.Date;
import org.apache.avro.util.Utf8;
import shaded.com.mongodb.BasicDBList;
import shaded.com.mongodb.BasicDBObject;
import shaded.com.mongodb.DBObject;

public class BSONDecorator {
    private final DBObject myBson;

    public BSONDecorator(DBObject obj) {
        this.myBson = obj;
    }

    public DBObject asDBObject() {
        return this.myBson;
    }

    public boolean containsField(String fieldName) {
        String[] fields = fieldName.split("\\.");
        DBObject intermediate = this.myBson;
        for (int i = 0; i < fields.length - 1; ++i) {
            if (!intermediate.containsField(fields[i])) {
                return false;
            }
            intermediate = (DBObject)intermediate.get(fields[i]);
        }
        return intermediate.containsField(fields[fields.length - 1]);
    }

    public BasicDBObject getDBObject(String fieldName) {
        return (BasicDBObject)this.getFieldParent(fieldName).get(this.getLeafName(fieldName));
    }

    public BasicDBList getDBList(String fieldName) {
        return (BasicDBList)this.getFieldParent(fieldName).get(this.getLeafName(fieldName));
    }

    public Boolean getBoolean(String fieldName) {
        String lf;
        BasicDBObject parent = this.getFieldParent(fieldName);
        return parent.containsField(lf = this.getLeafName(fieldName)) ? Boolean.valueOf(parent.getBoolean(lf)) : null;
    }

    public Double getDouble(String fieldName) {
        String lf;
        BasicDBObject parent = this.getFieldParent(fieldName);
        return parent.containsField(lf = this.getLeafName(fieldName)) ? Double.valueOf(parent.getDouble(lf)) : null;
    }

    public Integer getInt(String fieldName) {
        String lf;
        BasicDBObject parent = this.getFieldParent(fieldName);
        return parent.containsField(lf = this.getLeafName(fieldName)) && parent.get(lf) != null ? Integer.valueOf(parent.getInt(lf)) : null;
    }

    public Long getLong(String fieldName) {
        String lf;
        BasicDBObject parent = this.getFieldParent(fieldName);
        return parent.containsField(lf = this.getLeafName(fieldName)) ? Long.valueOf(parent.getLong(lf)) : null;
    }

    public Date getDate(String fieldName) {
        BasicDBObject parent = this.getFieldParent(fieldName);
        String lf = this.getLeafName(fieldName);
        return parent.getDate(lf);
    }

    public Utf8 getUtf8String(String fieldName) {
        BasicDBObject parent = this.getFieldParent(fieldName);
        String value = parent.getString(this.getLeafName(fieldName));
        return value != null ? new Utf8(value) : null;
    }

    public ByteBuffer getBytes(String fieldName) {
        Object o = this.get(fieldName);
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            return ByteBuffer.wrap((byte[])o);
        }
        return (ByteBuffer)o;
    }

    public Object get(String fieldName) {
        BasicDBObject parent = this.getFieldParent(fieldName);
        return parent.get(this.getLeafName(fieldName));
    }

    public void put(String fieldName, Object value) {
        BasicDBObject parent = this.getFieldParent(fieldName, true);
        parent.put(this.getLeafName(fieldName), value);
    }

    private BasicDBObject getFieldParent(String fieldName, boolean createIfMissing) {
        String[] fields = fieldName.split("\\.");
        BasicDBObject intermediate = (BasicDBObject)this.myBson;
        for (int i = 0; i < fields.length - 1; ++i) {
            if (!intermediate.containsField(fields[i])) {
                if (createIfMissing) {
                    intermediate.put(fields[i], new BasicDBObject());
                } else {
                    throw new IllegalAccessError("The field '" + fieldName + "' does not exist: '" + fields[i] + "' is missing.");
                }
            }
            intermediate = (BasicDBObject)intermediate.get(fields[i]);
        }
        return intermediate;
    }

    private BasicDBObject getFieldParent(String fieldName) {
        return this.getFieldParent(fieldName, false);
    }

    private String getLeafName(String fieldName) {
        int i = fieldName.lastIndexOf(".");
        if (i < 0) {
            return fieldName;
        }
        return fieldName.substring(i + 1);
    }
}

