/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.persistency.impl;

import java.lang.reflect.Constructor;
import org.apache.gora.persistency.BeanFactory;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.util.ClassLoadingUtils;
import org.apache.gora.util.GoraException;
import org.apache.gora.util.ReflectionUtils;

public class BeanFactoryImpl<K, T extends Persistent>
implements BeanFactory<K, T> {
    private Class<K> keyClass;
    private Class<T> persistentClass;
    private Constructor<K> keyConstructor;
    private K key;
    private T persistent;
    private boolean isKeyPersistent = false;

    public BeanFactoryImpl(Class<K> keyClass, Class<T> persistentClass) throws GoraException {
        this.keyClass = keyClass;
        this.persistentClass = persistentClass;
        try {
            if (ReflectionUtils.hasConstructor(keyClass)) {
                this.keyConstructor = ReflectionUtils.getConstructor(keyClass);
                this.key = this.keyConstructor.newInstance(ReflectionUtils.EMPTY_OBJECT_ARRAY);
            }
            this.persistent = (Persistent)ReflectionUtils.newInstance(persistentClass);
        }
        catch (Exception ex) {
            throw new GoraException(ex);
        }
        this.isKeyPersistent = Persistent.class.isAssignableFrom(keyClass);
    }

    public BeanFactoryImpl(Class<K> keyClass, String persistentClassName) throws ClassNotFoundException, GoraException {
        this(keyClass, ClassLoadingUtils.loadClass(persistentClassName));
    }

    @Override
    public K newKey() throws Exception {
        return this.keyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @Override
    public T newPersistent() {
        return (T)this.persistent.newInstance();
    }

    @Override
    public K getCachedKey() {
        return this.key;
    }

    @Override
    public T getCachedPersistent() {
        return this.persistent;
    }

    @Override
    public Class<K> getKeyClass() {
        return this.keyClass;
    }

    @Override
    public Class<T> getPersistentClass() {
        return this.persistentClass;
    }

    public boolean isKeyPersistent() {
        return this.isKeyPersistent;
    }
}

