/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.persistency.impl;

import java.util.Collection;
import java.util.Iterator;
import org.apache.gora.persistency.Dirtyable;
import org.apache.gora.persistency.impl.DirtyFlag;
import org.apache.gora.persistency.impl.DirtyIteratorWrapper;

public class DirtyCollectionWrapper<T>
implements Dirtyable,
Collection<T> {
    private final Collection<T> delegate;
    private DirtyFlag dirtyFlag;

    DirtyCollectionWrapper(Collection<T> delegate2, DirtyFlag dirtyFlag) {
        this.delegate = delegate2;
        this.dirtyFlag = dirtyFlag;
    }

    @Override
    public boolean isDirty() {
        boolean anyDirty = false;
        for (T value : this) {
            anyDirty = anyDirty || value instanceof Dirtyable ? ((Dirtyable)value).isDirty() : false;
        }
        return anyDirty || this.dirtyFlag.isDirty();
    }

    @Override
    public void clearDirty() {
        for (T value : this) {
            if (!(value instanceof Dirtyable)) continue;
            ((Dirtyable)value).clearDirty();
        }
        this.dirtyFlag.clearDirty();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new DirtyIteratorWrapper<T>(this.delegate.iterator(), this.dirtyFlag);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <R> R[] toArray(R[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean add(T e) {
        boolean change = this.delegate.add(e);
        this.dirtyFlag.makeDirty(change);
        return change;
    }

    @Override
    public boolean remove(Object o) {
        boolean change = this.delegate.remove(o);
        this.dirtyFlag.makeDirty(change);
        return change;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean change = this.delegate.addAll(c);
        this.dirtyFlag.makeDirty(change);
        return change;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean change = this.delegate.removeAll(c);
        this.dirtyFlag.makeDirty(change);
        return change;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean change = this.delegate.retainAll(c);
        this.dirtyFlag.makeDirty(change);
        return change;
    }

    @Override
    public void clear() {
        this.dirtyFlag.makeDirty(this.size() > 0);
        this.delegate.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    protected Collection<T> getDelegate() {
        return this.delegate;
    }

    protected DirtyFlag getDirtyFlag() {
        return this.dirtyFlag;
    }
}

