/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.persistency.impl;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.apache.gora.persistency.Dirtyable;
import org.apache.gora.persistency.impl.DirtyCollectionWrapper;
import org.apache.gora.persistency.impl.DirtyFlag;
import org.apache.gora.persistency.impl.DirtyListIterator;

public class DirtyListWrapper<T>
extends DirtyCollectionWrapper<T>
implements Dirtyable,
List<T> {
    public DirtyListWrapper(List<T> delegate) {
        this(delegate, new DirtyFlag());
    }

    DirtyListWrapper(List<T> delegate, DirtyFlag dirtyFlag) {
        super(delegate, dirtyFlag);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean change = this.getDelegate().addAll(index, c);
        this.getDirtyFlag().makeDirty(change);
        return change;
    }

    @Override
    public T get(int index) {
        return (T)this.getDelegate().get(index);
    }

    @Override
    public T set(int index, T element) {
        this.getDirtyFlag().makeDirty(true);
        return this.getDelegate().set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.getDirtyFlag().makeDirty(true);
        this.getDelegate().add(index, element);
    }

    @Override
    public T remove(int index) {
        this.getDirtyFlag().makeDirty(true);
        return (T)this.getDelegate().remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.getDelegate().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getDelegate().lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new DirtyListIterator(this.getDelegate().listIterator(), this.getDirtyFlag());
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new DirtyListIterator(this.getDelegate().listIterator(index), this.getDirtyFlag());
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return new DirtyListWrapper(this.getDelegate().subList(fromIndex, toIndex), this.getDirtyFlag());
    }

    @Override
    protected List<T> getDelegate() {
        return (List)super.getDelegate();
    }
}

