/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.persistency.impl;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.gora.persistency.Dirtyable;
import org.apache.gora.persistency.impl.DirtyCollectionWrapper;
import org.apache.gora.persistency.impl.DirtyFlag;
import org.apache.gora.persistency.impl.DirtySetWrapper;

public class DirtyMapWrapper<K, V>
implements Map<K, V>,
Dirtyable {
    private final Map<K, V> delegate;
    private final DirtyFlag dirtyFlag;

    public DirtyMapWrapper(Map<K, V> delegate) {
        this(delegate, new DirtyFlag());
    }

    DirtyMapWrapper(Map<K, V> delegate, DirtyFlag dirtyFlag) {
        this.dirtyFlag = dirtyFlag;
        this.delegate = delegate;
    }

    @Override
    public boolean isDirty() {
        boolean anyDirty = false;
        for (V v : this.values()) {
            anyDirty = anyDirty || v instanceof Dirtyable ? ((Dirtyable)v).isDirty() : false;
        }
        return anyDirty || this.dirtyFlag.isDirty();
    }

    @Override
    public void clearDirty() {
        for (V v : this.values()) {
            if (!(v instanceof Dirtyable)) continue;
            ((Dirtyable)v).clearDirty();
        }
        this.dirtyFlag.clearDirty();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public V put(K key, V value) {
        this.checkPutWillMakeDirty(key, value);
        return this.delegate.put(key, value);
    }

    private void checkPutWillMakeDirty(K key, V value) {
        if (this.containsKey(key)) {
            this.dirtyFlag.makeDirty(DirtyMapWrapper.valueChanged(value, this.get(key)));
        } else {
            this.dirtyFlag.makeDirty(true);
        }
    }

    private static <V> boolean valueChanged(V value, V oldValue) {
        return value == null && oldValue != null || value != null && !value.equals(oldValue);
    }

    @Override
    public V remove(Object key) {
        this.dirtyFlag.makeDirty(this.containsKey(key));
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.checkPutWillMakeDirty(entry.getKey(), entry.getValue());
        }
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        if (this.delegate.size() != 0) {
            this.dirtyFlag.makeDirty(true);
        }
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return new DirtyCollectionWrapper<V>(this.delegate.values(), this.dirtyFlag);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Collection dirtyEntrySet = Collections2.transform(this.delegate.entrySet(), (Function)new Function<Map.Entry<K, V>, DirtyEntryWrapper<K, V>>(){

            public DirtyEntryWrapper<K, V> apply(Map.Entry<K, V> input) {
                return new DirtyEntryWrapper(input, DirtyMapWrapper.this.dirtyFlag);
            }
        });
        return new DirtySetWrapper<Map.Entry<K, V>>(dirtyEntrySet, this.dirtyFlag);
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static class DirtyEntryWrapper<K, V>
    implements Map.Entry<K, V>,
    Dirtyable {
        private final Map.Entry<K, V> entryDelegate;
        private DirtyFlag dirtyFlag;

        public DirtyEntryWrapper(Map.Entry<K, V> delegate, DirtyFlag dirtyFlag) {
            this.entryDelegate = delegate;
            this.dirtyFlag = dirtyFlag;
        }

        @Override
        public K getKey() {
            return this.entryDelegate.getKey();
        }

        @Override
        public V getValue() {
            return this.entryDelegate.getValue();
        }

        @Override
        public V setValue(V value) {
            this.dirtyFlag.makeDirty(DirtyMapWrapper.valueChanged(value, this.entryDelegate.getValue()));
            return this.entryDelegate.setValue(value);
        }

        @Override
        public boolean equals(Object o) {
            return this.entryDelegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.entryDelegate.hashCode();
        }

        @Override
        public boolean isDirty() {
            return this.dirtyFlag.isDirty() || this.entryDelegate instanceof Dirtyable ? ((Dirtyable)this.entryDelegate.getValue()).isDirty() : false;
        }

        @Override
        public void clearDirty() {
            this.dirtyFlag.clearDirty();
        }
    }
}

