/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.query.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.Query;
import org.apache.gora.query.impl.PartitionQueryImpl;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class FileSplitPartitionQuery<K, T extends PersistentBase>
extends PartitionQueryImpl<K, T> {
    private FileSplit split;

    public FileSplitPartitionQuery() {
    }

    public FileSplitPartitionQuery(Query<K, T> baseQuery, FileSplit split) throws IOException {
        super(baseQuery, split.getLocations());
        this.split = split;
    }

    public FileSplit getSplit() {
        return this.split;
    }

    public long getLength() {
        return this.split.getLength();
    }

    public long getStart() {
        return this.split.getStart();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.split.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        if (this.split == null) {
            this.split = new FileSplit(null, 0L, 0L, null);
        }
        this.split.readFields(in);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FileSplitPartitionQuery) {
            return super.equals(obj) && this.split.equals(((FileSplitPartitionQuery)obj).split);
        }
        return false;
    }
}

