/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.query.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.gora.filter.Filter;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.PartitionQuery;
import org.apache.gora.query.Query;
import org.apache.gora.query.impl.QueryBase;
import org.apache.gora.store.DataStore;
import org.apache.gora.store.impl.DataStoreBase;
import org.apache.gora.util.IOUtils;

public class PartitionQueryImpl<K, T extends PersistentBase>
extends QueryBase<K, T>
implements PartitionQuery<K, T> {
    protected Query<K, T> baseQuery;
    protected String[] locations;

    public PartitionQueryImpl() {
        super(null);
    }

    public PartitionQueryImpl(Query<K, T> baseQuery, String ... locations) {
        this((Query<Object, T>)baseQuery, null, null, locations);
    }

    public PartitionQueryImpl(Query<K, T> baseQuery, K startKey, K endKey, String ... locations) {
        super(baseQuery.getDataStore());
        this.baseQuery = baseQuery;
        this.locations = locations;
        this.setStartKey(startKey);
        this.setEndKey(endKey);
        this.dataStore = (DataStoreBase)baseQuery.getDataStore();
    }

    @Override
    public String[] getLocations() {
        return this.locations;
    }

    public Query<K, T> getBaseQuery() {
        return this.baseQuery;
    }

    @Override
    public String[] getFields() {
        return this.baseQuery.getFields();
    }

    @Override
    public DataStore<K, T> getDataStore() {
        return this.baseQuery.getDataStore();
    }

    @Override
    public long getTimestamp() {
        return this.baseQuery.getTimestamp();
    }

    @Override
    public long getStartTime() {
        return this.baseQuery.getStartTime();
    }

    @Override
    public long getEndTime() {
        return this.baseQuery.getEndTime();
    }

    @Override
    public long getLimit() {
        return this.baseQuery.getLimit();
    }

    @Override
    public void setFields(String ... fields) {
        this.baseQuery.setFields(fields);
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.baseQuery.setTimestamp(timestamp);
    }

    @Override
    public void setStartTime(long startTime) {
        this.baseQuery.setStartTime(startTime);
    }

    @Override
    public void setEndTime(long endTime) {
        this.baseQuery.setEndTime(endTime);
    }

    @Override
    public void setTimeRange(long startTime, long endTime) {
        this.baseQuery.setTimeRange(startTime, endTime);
    }

    @Override
    public void setLimit(long limit) {
        this.baseQuery.setLimit(limit);
    }

    @Override
    public Filter<K, T> getFilter() {
        return this.baseQuery.getFilter();
    }

    @Override
    public void setFilter(Filter<K, T> filter) {
        this.baseQuery.setFilter(filter);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        IOUtils.serialize(this.getConf(), out, this.baseQuery);
        IOUtils.writeStringArray(out, this.locations);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        try {
            this.baseQuery = IOUtils.deserialize(this.getConf(), in, null);
        }
        catch (ClassNotFoundException ex) {
            throw new IOException(ex);
        }
        this.locations = IOUtils.readStringArray(in);
        this.dataStore = (DataStoreBase)this.baseQuery.getDataStore();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PartitionQueryImpl) {
            PartitionQueryImpl that = (PartitionQueryImpl)obj;
            return this.baseQuery.equals(that.baseQuery) && Arrays.equals(this.locations, that.locations);
        }
        return false;
    }
}

