/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.query.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.gora.filter.Filter;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.store.DataStore;
import org.apache.gora.store.impl.DataStoreBase;
import org.apache.gora.util.ClassLoadingUtils;
import org.apache.gora.util.GoraException;
import org.apache.gora.util.IOUtils;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.util.ReflectionUtils;

public abstract class QueryBase<K, T extends PersistentBase>
implements Query<K, T>,
Writable,
Configurable {
    protected DataStoreBase<K, T> dataStore;
    protected String queryString;
    protected String[] fields;
    protected K startKey;
    protected K endKey;
    protected long startTime = -1L;
    protected long endTime = -1L;
    protected Filter<K, T> filter;
    protected boolean localFilterEnabled = true;
    protected long limit = -1L;
    protected Configuration conf;

    public QueryBase(DataStore<K, T> dataStore) {
        this.dataStore = (DataStoreBase)dataStore;
    }

    @Override
    public Result<K, T> execute() throws GoraException {
        return this.dataStore.execute(this);
    }

    @Override
    public void setDataStore(DataStore<K, T> dataStore) {
        this.dataStore = (DataStoreBase)dataStore;
    }

    @Override
    public DataStore<K, T> getDataStore() {
        return this.dataStore;
    }

    @Override
    public void setFields(String ... fields) {
        this.fields = fields;
    }

    @Override
    public String[] getFields() {
        return this.fields;
    }

    @Override
    public Filter<K, T> getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter<K, T> filter) {
        this.filter = filter;
    }

    @Override
    public boolean isLocalFilterEnabled() {
        return this.localFilterEnabled;
    }

    @Override
    public void setLocalFilterEnabled(boolean enable) {
        this.localFilterEnabled = enable;
    }

    @Override
    public void setKey(K key) {
        this.setKeyRange(key, key);
    }

    @Override
    public void setStartKey(K startKey) {
        this.startKey = startKey;
    }

    @Override
    public void setEndKey(K endKey) {
        this.endKey = endKey;
    }

    @Override
    public void setKeyRange(K startKey, K endKey) {
        this.startKey = startKey;
        this.endKey = endKey;
    }

    @Override
    public K getKey() {
        if (this.startKey == this.endKey) {
            return this.startKey;
        }
        return null;
    }

    @Override
    public K getStartKey() {
        return this.startKey;
    }

    @Override
    public K getEndKey() {
        return this.endKey;
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.setTimeRange(timestamp, timestamp);
    }

    @Override
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Override
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Override
    public void setTimeRange(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Override
    public long getTimestamp() {
        return this.startTime == this.endTime ? this.startTime : -1L;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public void setLimit(long limit) {
        this.limit = limit;
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public void readFields(DataInput in) throws IOException {
        String dataStoreClass = Text.readString((DataInput)in);
        try {
            this.dataStore = (DataStoreBase)ReflectionUtils.newInstance(ClassLoadingUtils.loadClass(dataStoreClass), (Configuration)this.conf);
            this.dataStore.readFields(in);
        }
        catch (ClassNotFoundException ex) {
            throw new IOException(ex);
        }
        boolean[] nullFields = IOUtils.readNullFieldsInfo(in);
        if (!nullFields[0]) {
            this.queryString = Text.readString((DataInput)in);
        }
        if (!nullFields[1]) {
            this.fields = IOUtils.readStringArray(in);
        }
        if (!nullFields[2]) {
            this.startKey = IOUtils.deserialize(this.getConf(), in, null, this.dataStore.getKeyClass());
        }
        if (!nullFields[3]) {
            this.endKey = IOUtils.deserialize(this.getConf(), in, null, this.dataStore.getKeyClass());
        }
        if (!nullFields[4]) {
            String filterClass = Text.readString((DataInput)in);
            try {
                this.filter = (Filter)ReflectionUtils.newInstance(ClassLoadingUtils.loadClass(filterClass), (Configuration)this.conf);
                this.filter.readFields(in);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }
        this.startTime = WritableUtils.readVLong((DataInput)in);
        this.endTime = WritableUtils.readVLong((DataInput)in);
        this.limit = WritableUtils.readVLong((DataInput)in);
        this.localFilterEnabled = in.readBoolean();
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.dataStore.getClass().getCanonicalName());
        this.dataStore.write(out);
        IOUtils.writeNullFieldsInfo(out, this.queryString, this.fields, this.startKey, this.endKey, this.filter);
        if (this.queryString != null) {
            Text.writeString((DataOutput)out, (String)this.queryString);
        }
        if (this.fields != null) {
            IOUtils.writeStringArray(out, this.fields);
        }
        if (this.startKey != null) {
            IOUtils.serialize(this.getConf(), out, this.startKey, this.dataStore.getKeyClass());
        }
        if (this.endKey != null) {
            IOUtils.serialize(this.getConf(), out, this.endKey, this.dataStore.getKeyClass());
        }
        if (this.filter != null) {
            Text.writeString((DataOutput)out, (String)this.filter.getClass().getCanonicalName());
            this.filter.write(out);
        }
        WritableUtils.writeVLong((DataOutput)out, (long)this.getStartTime());
        WritableUtils.writeVLong((DataOutput)out, (long)this.getEndTime());
        WritableUtils.writeVLong((DataOutput)out, (long)this.getLimit());
        out.writeBoolean(this.localFilterEnabled);
    }

    public boolean equals(Object obj) {
        if (obj instanceof QueryBase) {
            QueryBase that = (QueryBase)obj;
            EqualsBuilder builder = new EqualsBuilder();
            builder.append(this.dataStore, that.dataStore);
            builder.append((Object)this.queryString, (Object)that.queryString);
            builder.append((Object[])this.fields, (Object[])that.fields);
            builder.append(this.startKey, that.startKey);
            builder.append(this.endKey, that.endKey);
            builder.append(this.filter, that.filter);
            builder.append(this.limit, that.limit);
            builder.append(this.localFilterEnabled, that.localFilterEnabled);
            return builder.isEquals();
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.dataStore);
        builder.append((Object)this.queryString);
        builder.append((Object[])this.fields);
        builder.append(this.startKey);
        builder.append(this.endKey);
        builder.append(this.filter);
        builder.append(this.limit);
        builder.append(this.localFilterEnabled);
        return builder.toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("dataStore", this.dataStore);
        builder.append("fields", (Object[])this.fields);
        builder.append("startKey", this.startKey);
        builder.append("endKey", this.endKey);
        builder.append("filter", this.filter);
        builder.append("limit", this.limit);
        builder.append("localFilterEnabled", this.localFilterEnabled);
        return builder.toString();
    }
}

