/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.query.ws.impl;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.gora.filter.Filter;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.store.DataStore;
import org.apache.gora.util.GoraException;

public abstract class QueryWSBase<K, T extends Persistent>
implements Query<K, T> {
    protected DataStore<K, T> dataStore;
    protected String queryString;
    protected String[] fields;
    protected K startKey;
    protected K endKey;
    protected long startTime = -1L;
    protected long endTime = -1L;
    protected Filter<K, T> filter;
    protected boolean localFilterEnabled = true;
    protected long limit = -1L;
    protected boolean isCompiled = false;
    private Object authentication;

    public QueryWSBase(DataStore<K, T> dataStore) {
        this.dataStore = dataStore;
    }

    @Override
    public Result<K, T> execute() throws GoraException {
        return this.dataStore.execute(this);
    }

    @Override
    public void setDataStore(DataStore<K, T> dataStore) {
        this.dataStore = dataStore;
    }

    @Override
    public DataStore<K, T> getDataStore() {
        return this.dataStore;
    }

    @Override
    public void setFields(String ... fields) {
        this.fields = fields;
    }

    @Override
    public String[] getFields() {
        return this.fields;
    }

    @Override
    public void setKey(K key) {
        this.setKeyRange(key, key);
    }

    @Override
    public void setStartKey(K startKey) {
        this.startKey = startKey;
    }

    @Override
    public void setEndKey(K endKey) {
        this.endKey = endKey;
    }

    @Override
    public void setKeyRange(K startKey, K endKey) {
        this.startKey = startKey;
        this.endKey = endKey;
    }

    @Override
    public K getKey() {
        if (this.startKey == this.endKey) {
            return this.startKey;
        }
        return null;
    }

    @Override
    public K getStartKey() {
        return this.startKey;
    }

    @Override
    public K getEndKey() {
        return this.endKey;
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.setTimeRange(timestamp, timestamp);
    }

    @Override
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Override
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Override
    public void setTimeRange(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Override
    public long getTimestamp() {
        return this.startTime == this.endTime ? this.startTime : -1L;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public void setLimit(long limit) {
        this.limit = limit;
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    public Object getConf() {
        return this.authentication;
    }

    public void setConf(Object auth) {
        this.authentication = auth;
    }

    public boolean equals(Object obj) {
        if (obj instanceof QueryWSBase) {
            QueryWSBase that = (QueryWSBase)obj;
            EqualsBuilder builder = new EqualsBuilder();
            builder.append(this.dataStore, that.dataStore);
            builder.append((Object)this.queryString, (Object)that.queryString);
            builder.append((Object[])this.fields, (Object[])that.fields);
            builder.append(this.startKey, that.startKey);
            builder.append(this.endKey, that.endKey);
            builder.append(this.filter, that.filter);
            builder.append(this.limit, that.limit);
            return builder.isEquals();
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.dataStore);
        builder.append((Object)this.queryString);
        builder.append((Object[])this.fields);
        builder.append(this.startKey);
        builder.append(this.endKey);
        builder.append(this.filter);
        builder.append(this.limit);
        return builder.toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("dataStore", this.dataStore);
        builder.append("fields", (Object[])this.fields);
        builder.append("startKey", this.startKey);
        builder.append("endKey", this.endKey);
        builder.append("filter", this.filter);
        builder.append("limit", this.limit);
        return builder.toString();
    }
}

