/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.spark;

import java.io.IOException;
import org.apache.gora.mapreduce.GoraInputFormat;
import org.apache.gora.mapreduce.GoraMapReduceUtils;
import org.apache.gora.mapreduce.GoraOutputFormat;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.store.DataStore;
import org.apache.gora.util.IOUtils;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;

public class GoraSparkEngine<K, V extends Persistent> {
    Class<K> clazzK;
    Class<V> clazzV;

    public GoraSparkEngine(Class<K> clazzK, Class<V> clazzV) {
        this.clazzK = clazzK;
        this.clazzV = clazzV;
    }

    public JavaPairRDD<K, V> initialize(JavaSparkContext sparkContext, Configuration conf, DataStore<K, V> dataStore) {
        GoraMapReduceUtils.setIOSerializations(conf, true);
        try {
            IOUtils.storeToConf(dataStore.newQuery(), conf, "gora.inputformat.query");
        }
        catch (IOException ioex) {
            throw new RuntimeException(ioex.getMessage());
        }
        return sparkContext.newAPIHadoopRDD(conf, GoraInputFormat.class, this.clazzK, this.clazzV);
    }

    public JavaPairRDD<K, V> initialize(JavaSparkContext sparkContext, DataStore<K, V> dataStore) {
        Configuration hadoopConf = dataStore instanceof Configurable && ((Configurable)dataStore).getConf() != null ? ((Configurable)dataStore).getConf() : new Configuration();
        return this.initialize(sparkContext, hadoopConf, dataStore);
    }

    public <K, V extends Persistent> Configuration generateOutputConf(DataStore<K, V> dataStore) throws IOException {
        Configuration hadoopConf = dataStore instanceof Configurable && ((Configurable)dataStore).getConf() != null ? ((Configurable)dataStore).getConf() : new Configuration();
        GoraMapReduceUtils.setIOSerializations(hadoopConf, true);
        Job job = Job.getInstance((Configuration)hadoopConf);
        return this.generateOutputConf(job, dataStore.getClass(), dataStore.getKeyClass(), dataStore.getPersistentClass());
    }

    public <K, V extends Persistent> Configuration generateOutputConf(Job job, DataStore<K, V> dataStore) {
        return this.generateOutputConf(job, dataStore.getClass(), dataStore.getKeyClass(), dataStore.getPersistentClass());
    }

    public <K, V extends Persistent> Configuration generateOutputConf(Job job, Class<? extends DataStore> dataStoreClass, Class<K> keyClass, Class<V> persistentClass) {
        job.setOutputFormatClass(GoraOutputFormat.class);
        job.setOutputKeyClass(keyClass);
        job.setOutputValueClass(persistentClass);
        job.getConfiguration().setClass("gora.outputformat.datastore.class", dataStoreClass, DataStore.class);
        job.getConfiguration().setClass("gora.outputformat.key.class", keyClass, Object.class);
        job.getConfiguration().setClass("gora.outputformat.value.class", persistentClass, Persistent.class);
        return job.getConfiguration();
    }
}

