/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.store;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.gora.persistency.BeanFactory;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.query.PartitionQuery;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.util.GoraException;

public interface DataStore<K, T extends Persistent> {
    public void initialize(Class<K> var1, Class<T> var2, Properties var3) throws GoraException;

    public void setKeyClass(Class<K> var1);

    public Class<K> getKeyClass();

    public void setPersistentClass(Class<T> var1);

    public Class<T> getPersistentClass();

    public String getSchemaName();

    public void createSchema() throws GoraException;

    public void deleteSchema() throws GoraException;

    public void truncateSchema() throws GoraException;

    public boolean schemaExists() throws GoraException;

    public K newKey() throws GoraException;

    public T newPersistent() throws GoraException;

    public boolean exists(K var1) throws GoraException;

    public T get(K var1) throws GoraException;

    public T get(K var1, String[] var2) throws GoraException;

    public void put(K var1, T var2) throws GoraException;

    public boolean delete(K var1) throws GoraException;

    public long deleteByQuery(Query<K, T> var1) throws GoraException;

    public Result<K, T> execute(Query<K, T> var1) throws GoraException;

    public Query<K, T> newQuery();

    public List<PartitionQuery<K, T>> getPartitions(Query<K, T> var1) throws IOException;

    public void flush() throws GoraException;

    public void setBeanFactory(BeanFactory<K, T> var1);

    public BeanFactory<K, T> getBeanFactory();

    public void close();
}

