/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.store;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.store.DataStore;
import org.apache.gora.store.impl.DataStoreBase;
import org.apache.gora.util.ClassLoadingUtils;
import org.apache.gora.util.GoraException;
import org.apache.gora.util.ReflectionUtils;
import org.apache.gora.util.StringUtils;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreFactory {
    public static final Logger log = LoggerFactory.getLogger(DataStoreFactory.class);
    public static final String GORA_DEFAULT_PROPERTIES_FILE = "gora.properties";
    public static final String GORA_DEFAULT_DATASTORE_KEY = "gora.datastore.default";
    public static final String GORA_DEFAULT_CACHE_DATASTORE_KEY = "gora.cache.datastore.default";
    public static final String GORA = "gora";
    public static final String DATASTORE = "datastore";
    private static final String GORA_DATASTORE = "gora.datastore.";
    public static final String AUTO_CREATE_SCHEMA = "autocreateschema";
    public static final String INPUT_PATH = "input.path";
    public static final String OUTPUT_PATH = "output.path";
    public static final String MAPPING_FILE = "mapping.file";
    public static final String SCHEMA_NAME = "schema.name";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties createProps() {
        try {
            Properties properties = new Properties();
            InputStream stream = DataStoreFactory.class.getClassLoader().getResourceAsStream(GORA_DEFAULT_PROPERTIES_FILE);
            if (stream == null) {
                log.warn("gora.properties not found, properties will be empty.");
                return properties;
            }
            try {
                properties.load(stream);
                Properties properties2 = properties;
                return properties2;
            }
            finally {
                stream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private DataStoreFactory() {
    }

    private static <K, T extends Persistent> void initializeDataStore(DataStore<K, T> dataStore, Class<K> keyClass, Class<T> persistent, Properties properties) throws IOException {
        dataStore.initialize(keyClass, persistent, properties);
    }

    public static <D extends DataStore<K, T>, K, T extends Persistent> D createDataStore(Class<D> dataStoreClass, Class<K> keyClass, Class<T> persistent, Configuration conf) throws GoraException {
        return DataStoreFactory.createDataStore(dataStoreClass, keyClass, persistent, conf, DataStoreFactory.createProps(), null);
    }

    public static <D extends DataStore<K, T>, K, T extends Persistent> D createDataStore(Class<D> dataStoreClass, Class<K> keyClass, Class<T> persistent, Configuration conf, String schemaName) throws GoraException {
        return DataStoreFactory.createDataStore(dataStoreClass, keyClass, persistent, conf, DataStoreFactory.createProps(), schemaName);
    }

    public static <D extends DataStore<K, T>, K, T extends Persistent> D createDataStore(Class<D> dataStoreClass, Class<K> keyClass, Class<T> persistent, Configuration conf, Properties properties, String schemaName) throws GoraException {
        try {
            DataStoreFactory.setDefaultSchemaName(properties, schemaName);
            DataStore dataStore = (DataStore)ReflectionUtils.newInstance(dataStoreClass);
            if (dataStore instanceof Configurable && conf != null) {
                ((Configurable)dataStore).setConf(conf);
            }
            DataStoreFactory.initializeDataStore(dataStore, keyClass, persistent, properties);
            return (D)dataStore;
        }
        catch (GoraException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new GoraException(ex);
        }
    }

    public static <D extends DataStore<K, T>, K, T extends Persistent> D createDataStore(Class<D> dataStoreClass, Class<K> keyClass, Class<T> persistent, Configuration conf, Properties properties) throws GoraException {
        if (properties == null || properties.size() == 0) {
            properties = DataStoreFactory.createProps();
        }
        return DataStoreFactory.createDataStore(dataStoreClass, keyClass, persistent, conf, properties, null);
    }

    public static <D extends DataStore<K, T>, K, T extends Persistent> D getDataStore(Class<D> dataStoreClass, Class<K> keyClass, Class<T> persistentClass, Configuration conf) throws GoraException {
        return DataStoreFactory.createDataStore(dataStoreClass, keyClass, persistentClass, conf, DataStoreFactory.createProps(), null);
    }

    public static <K, T extends Persistent> DataStore<K, T> getDataStore(String dataStoreClass, Class<K> keyClass, Class<T> persistentClass, Configuration conf) throws GoraException {
        try {
            Class<?> c = ClassLoadingUtils.loadClass(dataStoreClass);
            return DataStoreFactory.createDataStore(c, keyClass, persistentClass, conf, DataStoreFactory.createProps(), null);
        }
        catch (GoraException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new GoraException(ex);
        }
    }

    public static <K, T extends Persistent> DataStore<K, T> getDataStore(String dataStoreClass, String keyClass, String persistentClass, Configuration conf) throws GoraException {
        try {
            Class<?> c = Class.forName(dataStoreClass);
            Class<?> k = ClassLoadingUtils.loadClass(keyClass);
            Class<?> p = ClassLoadingUtils.loadClass(persistentClass);
            return DataStoreFactory.createDataStore(c, k, p, conf, DataStoreFactory.createProps(), null);
        }
        catch (GoraException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new GoraException(ex);
        }
    }

    public static <K, T extends Persistent> DataStore<K, T> getDataStore(String keyClass, String persistentClass, Properties props, Configuration conf) throws GoraException {
        try {
            Class<?> c = Class.forName(DataStoreFactory.getDefaultDataStore(props));
            Class<?> k = ClassLoadingUtils.loadClass(keyClass);
            Class<?> p = ClassLoadingUtils.loadClass(persistentClass);
            if (props == null || props.size() == 0) {
                props = DataStoreFactory.createProps();
            }
            return DataStoreFactory.createDataStore(c, k, p, conf, props, null);
        }
        catch (GoraException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new GoraException(ex);
        }
    }

    public static <K, T extends Persistent> DataStore<K, T> getDataStore(String dataStoreClass, String keyClass, String persistentClass, Properties props, Configuration conf) throws GoraException {
        try {
            Class<?> c = Class.forName(dataStoreClass);
            Class<?> k = ClassLoadingUtils.loadClass(keyClass);
            Class<?> p = ClassLoadingUtils.loadClass(persistentClass);
            if (props == null || props.size() == 0) {
                props = DataStoreFactory.createProps();
            }
            return DataStoreFactory.createDataStore(c, k, p, conf, props, null);
        }
        catch (GoraException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new GoraException(ex);
        }
    }

    public static <K, T extends Persistent> DataStore<K, T> getDataStore(Class<K> keyClass, Class<T> persistent, Configuration conf) throws GoraException {
        Class<?> c;
        Properties createProps = DataStoreFactory.createProps();
        try {
            c = Class.forName(DataStoreFactory.getDefaultDataStore(createProps));
        }
        catch (Exception ex) {
            throw new GoraException(ex);
        }
        return DataStoreFactory.createDataStore(c, keyClass, persistent, conf, createProps, null);
    }

    public static <K, T extends Persistent> DataStore<K, T> getDataStore(Class<K> keyClass, Class<T> persistent, Configuration conf, boolean isCacheEnabled) throws GoraException {
        Class<?> c;
        Properties createProps = DataStoreFactory.createProps();
        try {
            c = isCacheEnabled ? Class.forName(DataStoreFactory.getDefaultCacheDataStore(createProps)) : Class.forName(DataStoreFactory.getDefaultDataStore(createProps));
        }
        catch (Exception ex) {
            throw new GoraException(ex);
        }
        return DataStoreFactory.createDataStore(c, keyClass, persistent, conf, createProps, null);
    }

    public static String findProperty(Properties properties, DataStore<?, ?> store, String baseKey, String defaultValue) {
        String fullKey;
        String value;
        Class<?> clazz = store.getClass();
        do {
            if ((value = DataStoreFactory.getProperty(properties, fullKey = "gora." + StringUtils.getClassname(clazz).toLowerCase(Locale.getDefault()) + "." + baseKey)) != null) {
                return value;
            }
            value = DataStoreFactory.getProperty(properties, fullKey.toLowerCase(Locale.getDefault()));
            if (value == null) continue;
            return value;
        } while (!clazz.equals(DataStoreBase.class) && (clazz = clazz.getSuperclass()) != null);
        fullKey = GORA_DATASTORE + baseKey;
        value = DataStoreFactory.getProperty(properties, fullKey);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static String findPropertyOrDie(Properties properties, DataStore<?, ?> store, String baseKey) throws IOException {
        String val = DataStoreFactory.findProperty(properties, store, baseKey, null);
        if (val == null) {
            throw new IOException("Property with base name \"" + baseKey + "\" could not be found, make sure to include this property in gora.properties file");
        }
        return val;
    }

    public static boolean findBooleanProperty(Properties properties, DataStore<?, ?> store, String baseKey, String defaultValue) {
        return Boolean.parseBoolean(DataStoreFactory.findProperty(properties, store, baseKey, defaultValue));
    }

    public static boolean getAutoCreateSchema(Properties properties, DataStore<?, ?> store) {
        return DataStoreFactory.findBooleanProperty(properties, store, AUTO_CREATE_SCHEMA, "true");
    }

    public static String getInputPath(Properties properties, DataStore<?, ?> store) {
        return DataStoreFactory.findProperty(properties, store, INPUT_PATH, null);
    }

    public static String getOutputPath(Properties properties, DataStore<?, ?> store) {
        return DataStoreFactory.findProperty(properties, store, OUTPUT_PATH, null);
    }

    public static String getMappingFile(Properties properties, DataStore<?, ?> store, String defaultValue) throws IOException {
        String mappingFilename = DataStoreFactory.findProperty(properties, store, MAPPING_FILE, defaultValue);
        InputStream mappingFile = store.getClass().getClassLoader().getResourceAsStream(mappingFilename);
        if (mappingFile == null) {
            throw new IOException("Unable to open mapping file: " + mappingFilename);
        }
        mappingFile.close();
        return mappingFilename;
    }

    public static String getDefaultDataStore(Properties properties) {
        return DataStoreFactory.getProperty(properties, GORA_DEFAULT_DATASTORE_KEY);
    }

    private static String getDefaultCacheDataStore(Properties properties) {
        return DataStoreFactory.getProperty(properties, GORA_DEFAULT_CACHE_DATASTORE_KEY);
    }

    private static String getProperty(Properties properties, String key) {
        return DataStoreFactory.getProperty(properties, key, null);
    }

    private static String getProperty(Properties properties, String key, String defaultValue) {
        String result;
        String regex = "[a-z_\\.]*";
        if (properties == null) {
            return defaultValue;
        }
        if (!key.matches(regex)) {
            log.warn("Keys should be LOWERCASE. Please change that!");
            log.warn("Using lowecase for key " + key);
            key = key.toLowerCase(Locale.getDefault());
        }
        if ((result = properties.getProperty(key)) == null) {
            return defaultValue;
        }
        return result;
    }

    private static void setProperty(Properties properties, String baseKey, String value) {
        if (value != null) {
            properties.setProperty(GORA_DATASTORE + baseKey, value);
        }
    }

    private static <D extends DataStore<K, T>, K, T extends Persistent> void setProperty(Properties properties, Class<D> dataStoreClass, String baseKey, String value) {
        properties.setProperty("gora." + StringUtils.getClassname(dataStoreClass) + "." + baseKey, value);
    }

    public static String getDefaultSchemaName(Properties properties, DataStore<?, ?> store) {
        return DataStoreFactory.findProperty(properties, store, SCHEMA_NAME, null);
    }

    public static void setDefaultSchemaName(Properties properties, String schemaName) {
        if (schemaName != null) {
            DataStoreFactory.setProperty(properties, SCHEMA_NAME, schemaName);
        }
    }

    public static <D extends DataStore<K, T>, K, T extends Persistent> void setDefaultSchemaName(Properties properties, Class<D> dataStoreClass, String schemaName) {
        DataStoreFactory.setProperty(properties, dataStoreClass, SCHEMA_NAME, schemaName);
    }
}

