/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.store;

import java.util.Properties;
import org.apache.gora.store.DataStoreFactory;
import org.apache.gora.store.impl.DataStoreMetadataAnalyzer;
import org.apache.gora.util.GoraException;
import org.apache.gora.util.ReflectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreMetadataFactory {
    public static final Logger log = LoggerFactory.getLogger(DataStoreMetadataFactory.class);

    private DataStoreMetadataFactory() {
    }

    public static DataStoreMetadataAnalyzer createAnalyzer(Configuration configuration) throws GoraException, ClassNotFoundException {
        return DataStoreMetadataFactory.createAnalyzer(configuration, DataStoreFactory.createProps());
    }

    public static DataStoreMetadataAnalyzer createAnalyzer(Configuration configuration, Properties properties) throws GoraException, ClassNotFoundException {
        String metadataAnalyzerClassName = DataStoreFactory.getDefaultDataStore(properties) + "MetadataAnalyzer";
        return DataStoreMetadataFactory.createAnalyzer(metadataAnalyzerClassName, configuration, properties);
    }

    public static DataStoreMetadataAnalyzer createAnalyzer(String metadataAnalyzerClassName, Configuration configuration) throws GoraException, ClassNotFoundException {
        return DataStoreMetadataFactory.createAnalyzer(metadataAnalyzerClassName, configuration, DataStoreFactory.createProps());
    }

    public static DataStoreMetadataAnalyzer createAnalyzer(String metadataAnalyzerClassName, Configuration configuration, Properties properties) throws GoraException, ClassNotFoundException {
        try {
            DataStoreMetadataAnalyzer metadataAnalyzer = (DataStoreMetadataAnalyzer)ReflectionUtils.newInstance(metadataAnalyzerClassName);
            metadataAnalyzer.setConf(configuration);
            metadataAnalyzer.initialize();
            return metadataAnalyzer;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (GoraException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GoraException(e);
        }
    }
}

