/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.store.impl;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.gora.avro.store.AvroStore;
import org.apache.gora.mapreduce.GoraMapReduceUtils;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.PartitionQuery;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.query.impl.FileSplitPartitionQuery;
import org.apache.gora.store.DataStoreFactory;
import org.apache.gora.store.FileBackedDataStore;
import org.apache.gora.store.impl.DataStoreBase;
import org.apache.gora.util.GoraException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileBackedDataStoreBase<K, T extends PersistentBase>
extends DataStoreBase<K, T>
implements FileBackedDataStore<K, T> {
    protected long inputSize;
    protected String inputPath;
    protected String outputPath;
    protected InputStream inputStream;
    protected OutputStream outputStream;
    public static final Logger LOG = LoggerFactory.getLogger(AvroStore.class);

    @Override
    public void initialize(Class<K> keyClass, Class<T> persistentClass, Properties properties) throws GoraException {
        super.initialize(keyClass, persistentClass, properties);
        if (properties != null) {
            if (this.inputPath == null) {
                this.inputPath = DataStoreFactory.getInputPath(properties, this);
            }
            if (this.outputPath == null) {
                this.outputPath = DataStoreFactory.getOutputPath(properties, this);
            }
        }
    }

    @Override
    public void setInputPath(String inputPath) {
        this.inputPath = inputPath;
    }

    @Override
    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    @Override
    public String getInputPath() {
        return this.inputPath;
    }

    @Override
    public String getOutputPath() {
        return this.outputPath;
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    protected InputStream createInputStream() throws IOException {
        Path path = new Path(this.inputPath);
        FileSystem fs = path.getFileSystem(this.getConf());
        this.inputSize = fs.getFileStatus(path).getLen();
        return fs.open(path);
    }

    protected OutputStream createOutputStream() {
        FSDataOutputStream conf = null;
        try {
            Path path = new Path(this.outputPath);
            FileSystem fs = path.getFileSystem(this.getConf());
            conf = fs.create(path);
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return conf;
    }

    protected InputStream getOrCreateInputStream() throws IOException {
        try {
            if (this.inputStream == null) {
                this.inputStream = this.createInputStream();
            }
            return this.inputStream;
        }
        catch (IOException ex) {
            throw new IOException(ex);
        }
    }

    protected OutputStream getOrCreateOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = this.createOutputStream();
        }
        return this.outputStream;
    }

    @Override
    public List<PartitionQuery<K, T>> getPartitions(Query<K, T> query) throws IOException {
        List<InputSplit> splits = null;
        ArrayList<PartitionQuery<K, T>> queries = null;
        splits = GoraMapReduceUtils.getSplits(this.getConf(), this.inputPath);
        queries = new ArrayList<PartitionQuery<K, T>>(splits.size());
        for (InputSplit split : splits) {
            queries.add(new FileSplitPartitionQuery<K, T>(query, (FileSplit)split));
        }
        return queries;
    }

    @Override
    public Result<K, T> execute(Query<K, T> query) throws GoraException {
        Result<K, T> results = null;
        try {
            results = query instanceof FileSplitPartitionQuery ? this.executePartial((FileSplitPartitionQuery)query) : this.executeQuery(query);
        }
        catch (GoraException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GoraException(e);
        }
        return results;
    }

    protected abstract Result<K, T> executeQuery(Query<K, T> var1) throws IOException;

    protected abstract Result<K, T> executePartial(FileSplitPartitionQuery<K, T> var1) throws IOException;

    @Override
    public void flush() throws GoraException {
        try {
            if (this.outputStream != null) {
                this.outputStream.flush();
            }
        }
        catch (Exception e) {
            throw new GoraException(e);
        }
    }

    @Override
    public void createSchema() throws GoraException {
    }

    @Override
    public void deleteSchema() throws GoraException {
        throw new GoraException("delete schema is not supported for file backed data stores");
    }

    @Override
    public boolean schemaExists() throws GoraException {
        return true;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        org.apache.gora.util.IOUtils.writeNullFieldsInfo(out, this.inputPath, this.outputPath);
        if (this.inputPath != null) {
            Text.writeString((DataOutput)out, (String)this.inputPath);
        }
        if (this.outputPath != null) {
            Text.writeString((DataOutput)out, (String)this.outputPath);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        try {
            super.readFields(in);
            boolean[] nullFields = org.apache.gora.util.IOUtils.readNullFieldsInfo(in);
            if (!nullFields[0]) {
                this.inputPath = Text.readString((DataInput)in);
            }
            if (!nullFields[1]) {
                this.outputPath = Text.readString((DataInput)in);
            }
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void close() {
        IOUtils.closeStream((Closeable)this.inputStream);
        IOUtils.closeStream((Closeable)this.outputStream);
        this.inputStream = null;
        this.outputStream = null;
    }
}

