/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.store.ws.impl;

import java.io.IOException;
import java.util.Properties;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.query.Query;
import org.apache.gora.query.Result;
import org.apache.gora.store.WebServiceBackedDataStore;
import org.apache.gora.store.ws.impl.WSDataStoreBase;
import org.apache.gora.util.GoraException;
import org.apache.gora.util.OperationNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WSBackedDataStoreBase<K, T extends Persistent>
extends WSDataStoreBase<K, T>
implements WebServiceBackedDataStore<K, T> {
    private static final Logger LOG = LoggerFactory.getLogger(WSBackedDataStoreBase.class);

    @Override
    public void initialize(Class<K> keyClass, Class<T> persistentClass, Properties properties) throws GoraException {
        super.initialize(keyClass, persistentClass, properties);
    }

    @Override
    public Result<K, T> execute(Query<K, T> query) throws GoraException {
        try {
            return this.executeQuery(query);
        }
        catch (IOException e) {
            throw new GoraException(e);
        }
    }

    protected abstract Result<K, T> executeQuery(Query<K, T> var1) throws IOException;

    @Override
    public void flush() throws GoraException {
    }

    @Override
    public void createSchema() throws GoraException {
    }

    @Override
    public void deleteSchema() throws GoraException {
        throw new OperationNotSupportedException("delete schema is not supported for file backed data stores");
    }

    @Override
    public boolean schemaExists() throws GoraException {
        return true;
    }

    @Override
    public void write(Object out) throws Exception {
        super.write(out);
    }

    @Override
    public void readFields(Object in) throws Exception {
        super.readFields(in);
    }

    @Override
    public void close() {
    }
}

